/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.hasor.jdbc.datasource.DataSourceHelper;
import net.hasor.jdbc.datasource.local.DefaultDataSourceHelper;
import net.hasor.jdbc.exceptions.DataAccessException;
import org.more.util.ContextClassLoaderLocal;

public class DataSourceUtils {
    private static ServiceLocal utilServiceLocal = new ServiceLocal();

    public static Connection getConnection(DataSource dataSource) throws DataAccessException {
        DataSourceHelper utilService = (DataSourceHelper)utilServiceLocal.get();
        try {
            Connection conn = utilService.getConnection(dataSource);
            if (conn == null) {
                throw new DataAccessException("getConnection. return null.");
            }
            return conn;
        }
        catch (SQLException e) {
            throw new DataAccessException("getConnection.", e);
        }
    }

    public static void releaseConnection(Connection con, DataSource dataSource) throws DataAccessException {
        DataSourceHelper utilService = (DataSourceHelper)utilServiceLocal.get();
        try {
            utilService.releaseConnection(con, dataSource);
        }
        catch (SQLException e) {
            throw new DataAccessException("releaseConnection.", e);
        }
    }

    public static Connection currentConnection(DataSource dataSource) throws DataAccessException {
        try {
            DataSourceHelper utilService = (DataSourceHelper)utilServiceLocal.get();
            return utilService.currentConnection(dataSource);
        }
        catch (SQLException e) {
            throw new DataAccessException("currentConnection.", e);
        }
    }

    public static DataSourceHelper getDataSourceHelper() {
        return (DataSourceHelper)utilServiceLocal.get();
    }

    protected static void changeDataSourceUtilService(DataSourceHelper utilService) {
        utilServiceLocal.set(utilService);
    }

    private static class ServiceLocal
    extends ContextClassLoaderLocal<DataSourceHelper> {
        private ServiceLocal() {
        }

        protected DataSourceHelper initialValue() {
            return new DefaultDataSourceHelper();
        }
    }
}

