/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.datasource.local;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import net.hasor.jdbc.datasource.SavepointManager;
import net.hasor.jdbc.exceptions.DataAccessException;

public class ConnectionHolder
implements SavepointManager {
    private int referenceCount;
    private DataSource dataSource;
    private Connection connection;
    public static final String SAVEPOINT_NAME_PREFIX = "SAVEPOINT_";
    private int savepointCounter = 0;
    private Boolean savepointsSupported;

    public ConnectionHolder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public synchronized void requested() {
        ++this.referenceCount;
    }

    public synchronized void released() {
        --this.referenceCount;
        if (!this.isOpen() && this.connection != null) {
            try {
                this.savepointCounter = 0;
                this.savepointsSupported = null;
                this.connection.close();
            }
            catch (SQLException e) {
                throw new DataAccessException("cant not close connection.", e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public boolean isOpen() {
        return this.referenceCount != 0;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (!this.isOpen()) {
            return null;
        }
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    private void checkConn(Connection conn) throws SQLException {
        if (conn == null) {
            throw new SQLException("Connection is null.");
        }
    }

    public boolean supportsSavepoints() throws SQLException {
        Connection conn = this.getConnection();
        this.checkConn(conn);
        if (this.savepointsSupported == null) {
            this.savepointsSupported = conn.getMetaData().supportsSavepoints();
        }
        return this.savepointsSupported;
    }

    @Override
    public Savepoint createSavepoint() throws SQLException {
        Connection conn = this.getConnection();
        this.checkConn(conn);
        ++this.savepointCounter;
        return conn.setSavepoint(SAVEPOINT_NAME_PREFIX + this.savepointCounter);
    }

    @Override
    public void rollbackToSavepoint(Savepoint savepoint) throws SQLException {
        Connection conn = this.getConnection();
        this.checkConn(conn);
        conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Connection conn = this.getConnection();
        this.checkConn(conn);
        conn.releaseSavepoint(savepoint);
    }
}

