/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.datasource.local;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.jdbc.datasource.SavepointDataSourceHelper;
import net.hasor.jdbc.datasource.SavepointManager;
import net.hasor.jdbc.datasource.local.ConnectionHolder;

public class DefaultDataSourceHelper
implements SavepointDataSourceHelper {
    private static final ThreadLocal<Map<DataSource, ConnectionHolder>> ResourcesLocal = new ThreadLocal();

    private static void initLocal() {
        if (ResourcesLocal.get() == null) {
            ResourcesLocal.set(new HashMap());
        }
    }

    @Override
    public Connection getConnection(DataSource dataSource) throws SQLException {
        ConnectionHolder holder = this.getConnectionHolder(dataSource);
        holder.requested();
        return holder.getConnection();
    }

    @Override
    public void releaseConnection(Connection con, DataSource dataSource) throws SQLException {
        DefaultDataSourceHelper.initLocal();
        ConnectionHolder holder = ResourcesLocal.get().get(dataSource);
        if (holder == null) {
            return;
        }
        holder.released();
        if (!holder.isOpen()) {
            ResourcesLocal.get().remove(dataSource);
        }
    }

    @Override
    public Connection currentConnection(DataSource dataSource) throws SQLException {
        ConnectionHolder holder = this.getConnectionHolder(dataSource);
        return holder.getConnection();
    }

    @Override
    public SavepointManager getSavepointManager(DataSource dataSource) throws SQLException {
        return this.getConnectionHolder(dataSource);
    }

    protected ConnectionHolder getConnectionHolder(DataSource dataSource) {
        DefaultDataSourceHelper.initLocal();
        ConnectionHolder holder = ResourcesLocal.get().get(dataSource);
        if (holder == null) {
            holder = this.createConnectionHolder(dataSource);
            ResourcesLocal.get().put(dataSource, holder);
        }
        return holder;
    }

    protected ConnectionHolder createConnectionHolder(DataSource dataSource) {
        return new ConnectionHolder(dataSource);
    }
}

