/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.parameter;

import java.util.LinkedList;
import java.util.List;
import net.hasor.core.Hasor;

public class SqlParameter {
    private String name;
    private final int sqlType;
    private Integer scale;

    public SqlParameter(int sqlType) {
        this.sqlType = sqlType;
    }

    public SqlParameter(int sqlType, Integer scale) {
        this.sqlType = sqlType;
        this.scale = scale;
    }

    public SqlParameter(String name, int sqlType) {
        this.name = name;
        this.sqlType = sqlType;
    }

    public SqlParameter(String name, int sqlType, Integer scale) {
        this.name = name;
        this.sqlType = sqlType;
        this.scale = scale;
    }

    public SqlParameter(SqlParameter otherParam) {
        Hasor.assertIsNotNull((Object)otherParam, (String)"SqlParameter object must not be null");
        this.name = otherParam.name;
        this.sqlType = otherParam.sqlType;
        this.scale = otherParam.scale;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Integer getScale() {
        return this.scale;
    }

    public static List<SqlParameter> sqlTypesToAnonymousParameterList(int[] types) {
        LinkedList<SqlParameter> result = new LinkedList<SqlParameter>();
        if (types != null) {
            for (int type : types) {
                result.add(new SqlParameter(type));
            }
        }
        return result;
    }
}

