/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.datasource;

import java.util.List;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.Environment;
import net.hasor.core.Hasor;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import net.hasor.core.plugin.AbstractHasorPlugin;
import net.hasor.core.plugin.Plugin;
import net.hasor.plugins.datasource.DataSourceFactory;
import org.more.util.StringUtils;

@Plugin
public class DataSourcePlugin
extends AbstractHasorPlugin {
    public void loadPlugin(ApiBinder apiBinder) {
        Environment env = apiBinder.getEnvironment();
        Settings settings = env.getSettings();
        String defaultDS = settings.getString("hasor-jdbc.dataSourceSet.default");
        XmlNode[] dataSourceSet = settings.getXmlPropertyArray("hasor-jdbc.dataSourceSet");
        if (dataSourceSet == null) {
            return;
        }
        for (XmlNode dsSet : dataSourceSet) {
            List dataSource = dsSet.getChildren("dataSource");
            for (XmlNode dsConfig : dataSource) {
                String name = dsConfig.getAttribute("name");
                String dsFactoryClass = dsConfig.getAttribute("dsFactory");
                DataSource dataSourceObject = null;
                try {
                    Class<?> dsFactoryType = Thread.currentThread().getContextClassLoader().loadClass(dsFactoryClass);
                    DataSourceFactory dsFactory = (DataSourceFactory)dsFactoryType.newInstance();
                    dataSourceObject = dsFactory.createDataSource(env, dsConfig);
                    if (dataSourceObject == null) {
                        Hasor.logWarn((String)"\u2018%s\u2019 dataSource is null.", (Object[])new Object[]{name});
                        continue;
                    }
                    Hasor.logInfo((String)"\u2018%s\u2019 dataSource is defined.", (Object[])new Object[]{name});
                    apiBinder.bindingType(name, DataSource.class).toInstance((Object)dataSourceObject);
                    apiBinder.bindingType(name, DataSourceFactory.class).toInstance((Object)dsFactory);
                    if (!StringUtils.equalsIgnoreCase((String)name, (String)defaultDS)) continue;
                    apiBinder.getGuiceBinder().bind(DataSource.class).toInstance((Object)dataSourceObject);
                    Hasor.logInfo((String)"\u2018%s\u2019 dataSource is default.", (Object[])new Object[]{name});
                }
                catch (Throwable e) {
                    apiBinder.getGuiceBinder().addError(e);
                    Hasor.logError((String)" %s dataSource error.%s", (Object[])new Object[]{name, e});
                }
            }
        }
    }
}

