/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.datasource.factory;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import javax.sql.DataSource;
import net.hasor.core.Environment;
import net.hasor.core.Hasor;
import net.hasor.core.XmlNode;
import net.hasor.plugins.datasource.DataSourceFactory;

public class C3p0Factory
implements DataSourceFactory {
    @Override
    public DataSource createDataSource(Environment env, XmlNode configElement) throws Throwable {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        String driverString = configElement.getOneChildren("driver").getText();
        String urlString = configElement.getOneChildren("url").getText();
        String userString = configElement.getOneChildren("user").getText();
        String pwdString = configElement.getOneChildren("password").getText();
        int poolMaxSize = 200;
        Hasor.logInfo((String)"C3p0 Pool Info maxSize is \u2018%s\u2019 driver is \u2018%s\u2019 jdbcUrl is\u2018%s\u2019", (Object[])new Object[]{poolMaxSize, driverString, urlString});
        dataSource.setDriverClass(driverString);
        dataSource.setJdbcUrl(urlString);
        dataSource.setUser(userString);
        dataSource.setPassword(pwdString);
        dataSource.setMaxPoolSize(poolMaxSize);
        dataSource.setInitialPoolSize(1);
        dataSource.setAutomaticTestTable("DB_TEST_ATest001");
        dataSource.setIdleConnectionTestPeriod(18000);
        dataSource.setCheckoutTimeout(3000);
        dataSource.setTestConnectionOnCheckin(true);
        dataSource.setAcquireRetryDelay(1000);
        dataSource.setAcquireRetryAttempts(30);
        dataSource.setAcquireIncrement(1);
        dataSource.setMaxIdleTime(25000);
        return dataSource;
    }
}

