/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.datasource.factory;

import javax.sql.DataSource;
import net.hasor.core.Environment;
import net.hasor.core.Hasor;
import net.hasor.core.XmlNode;
import net.hasor.plugins.datasource.DataSourceFactory;
import org.apache.commons.dbcp.BasicDataSource;

public class DbcpFactory
implements DataSourceFactory {
    @Override
    public DataSource createDataSource(Environment env, XmlNode configElement) throws Throwable {
        BasicDataSource dataSource = new BasicDataSource();
        String driverString = configElement.getOneChildren("driver").getText();
        String urlString = configElement.getOneChildren("url").getText();
        String userString = configElement.getOneChildren("user").getText();
        String pwdString = configElement.getOneChildren("password").getText();
        int poolMaxSize = 200;
        Hasor.logInfo((String)"DBCP Pool Info maxSize is \u2018%s\u2019 driver is \u2018%s\u2019 jdbcUrl is\u2018%s\u2019", (Object[])new Object[]{poolMaxSize, driverString, urlString});
        dataSource.setDriverClassName(driverString);
        dataSource.setUrl(urlString);
        dataSource.setUsername(userString);
        dataSource.setPassword(pwdString);
        dataSource.setMaxActive(poolMaxSize);
        dataSource.setInitialSize(1);
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("select 'ok' as msg");
        return dataSource;
    }
}

