/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.datasource.factory;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import net.hasor.core.Environment;
import net.hasor.core.Hasor;
import net.hasor.core.XmlNode;
import net.hasor.plugins.datasource.DataSourceFactory;

public class DruidFactory
implements DataSourceFactory {
    @Override
    public DataSource createDataSource(Environment env, XmlNode configElement) throws Throwable {
        DruidDataSource dataSource = new DruidDataSource();
        String driverString = configElement.getOneChildren("driver").getText();
        String urlString = configElement.getOneChildren("url").getText();
        String userString = configElement.getOneChildren("user").getText();
        String pwdString = configElement.getOneChildren("password").getText();
        int poolMaxSize = 200;
        Hasor.logInfo((String)"Druid Pool Info maxSize is \u2018%s\u2019 driver is \u2018%s\u2019 jdbcUrl is\u2018%s\u2019", (Object[])new Object[]{poolMaxSize, driverString, urlString});
        dataSource.setDriverClassName(driverString);
        dataSource.setUrl(urlString);
        dataSource.setUsername(userString);
        dataSource.setPassword(pwdString);
        dataSource.setFilters("stat");
        dataSource.setMaxActive(poolMaxSize);
        dataSource.setInitialSize(1);
        dataSource.setMaxWait(60000L);
        dataSource.setMinIdle(1);
        dataSource.setTimeBetweenEvictionRunsMillis(3000L);
        dataSource.setMinEvictableIdleTimeMillis(300000L);
        dataSource.setValidationQuery("SELECT 'x'");
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(20);
        dataSource.init();
        return dataSource;
    }
}

