/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.template;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.AppContextAware;
import net.hasor.core.EventListener;
import net.hasor.core.Settings;
import net.hasor.core.XmlNode;
import net.hasor.core.plugin.AbstractHasorPlugin;
import net.hasor.core.plugin.Plugin;
import net.hasor.jdbc.core.JdbcTemplate;
import org.more.util.StringUtils;

@Plugin
public class TemplatePlugin
extends AbstractHasorPlugin {
    public void loadPlugin(ApiBinder apiBinder) {
        apiBinder.getGuiceBinder().bind(JdbcTemplate.class).toProvider((Provider)new DefaultJdbcTemplateProvider(apiBinder));
        Settings settings = apiBinder.getEnvironment().getSettings();
        XmlNode[] dataSourceSet = settings.getXmlPropertyArray("hasor-jdbc.dataSourceSet");
        if (dataSourceSet == null) {
            return;
        }
        ArrayList<String> dataSourceNames = new ArrayList<String>();
        for (XmlNode dsSet : dataSourceSet) {
            List dataSource = dsSet.getChildren("dataSource");
            for (XmlNode dsConfig : dataSource) {
                String name = dsConfig.getAttribute("name");
                if (StringUtils.isBlank((String)name)) continue;
                dataSourceNames.add(name);
            }
        }
        apiBinder.getEventManager().pushListener("ContextEvent_Initialized", (EventListener)new InitializedEventListener(dataSourceNames));
    }

    private static class JdbcTemplateProvider
    implements Provider<JdbcTemplate>,
    AppContextAware {
        private String name;
        private AppContext appContext;

        public void setAppContext(AppContext appContext) {
            this.appContext = appContext;
        }

        public JdbcTemplateProvider(String name, ApiBinder apiBinder) {
            this.name = name;
            apiBinder.registerAware((AppContextAware)this);
        }

        public JdbcTemplate get() {
            DataSource dataSource = (DataSource)this.appContext.findBeanByType(this.name, DataSource.class);
            if (dataSource == null) {
                throw new NullPointerException(this.name + " DataSource is not define.");
            }
            return new JdbcTemplate(dataSource);
        }
    }

    private static class DefaultJdbcTemplateProvider
    implements Provider<JdbcTemplate>,
    AppContextAware {
        private AppContext appContext;

        public void setAppContext(AppContext appContext) {
            this.appContext = appContext;
        }

        public DefaultJdbcTemplateProvider(ApiBinder apiBinder) {
            apiBinder.registerAware((AppContextAware)this);
        }

        public JdbcTemplate get() {
            DataSource dataSource = (DataSource)this.appContext.getInstance(DataSource.class);
            return new JdbcTemplate(dataSource);
        }
    }

    private static class InitializedEventListener
    implements EventListener {
        private List<String> dataSourceNames;

        public InitializedEventListener(List<String> dataSourceNames) {
            this.dataSourceNames = dataSourceNames;
        }

        public void onEvent(String event, Object[] params) throws Throwable {
            if (this.dataSourceNames == null || this.dataSourceNames.isEmpty()) {
                return;
            }
            ApiBinder apiBinder = (ApiBinder)params[0];
            for (String name : this.dataSourceNames) {
                JdbcTemplateProvider jdbcProvider = new JdbcTemplateProvider(name, apiBinder);
                apiBinder.bindingType(name, JdbcTemplate.class).toProvider((Provider)jdbcProvider);
            }
        }
    }
}

