/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Node;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTJavaCompiler
implements JavaCompiler {
    private final Map settings = new HashMap();
    private JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private Logger log;
    private String javaFileName;
    private static boolean USE_INTROSPECTION_TO_INVOKE_GET_PROBLEM = false;
    private static Method GET_PROBLEM_METH = null;

    @Override
    public void init(JspCompilationContext ctxt, ErrorDispatcher errDispatcher, boolean suppressLogging) {
        this.errDispatcher = errDispatcher;
        this.ctxt = ctxt;
        this.log = Logger.getLogger(JDTJavaCompiler.class.getName());
        if (suppressLogging) {
            this.log.setLevel(Level.OFF);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void setExtdirs(String exts) {
    }

    @Override
    public void setClassPath(List<File> cpath) {
    }

    @Override
    public long getClassLastModified() {
        File classFile = new File(this.ctxt.getClassFileName());
        return classFile.lastModified();
    }

    @Override
    public Writer getJavaWriter(String javaFileName, String javaEncoding) throws JasperException {
        this.javaFileName = javaFileName;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
        }
        catch (IOException ex) {
            this.errDispatcher.jspError("jsp.error.unableToCreateOutputWriter", javaFileName, ex);
        }
        return writer;
    }

    @Override
    public void setDebug(boolean debug) {
        this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        if (debug) {
            this.settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
    }

    @Override
    public void setSourceVM(String sourceVM) {
        if (sourceVM.equals("1.1")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.1");
        } else if (sourceVM.equals("1.2")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.2");
        } else if (sourceVM.equals("1.3")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.3");
        } else if (sourceVM.equals("1.4")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
        } else if (sourceVM.equals("1.5")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        } else {
            this.log.warning("Unknown source VM " + sourceVM + " ignored.");
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        }
    }

    @Override
    public void setTargetVM(String targetVM) {
        if (targetVM.equals("1.1")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
        } else if (targetVM.equals("1.2")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        } else if (targetVM.equals("1.3")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
        } else if (targetVM.equals("1.4")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        } else if (targetVM.equals("1.5")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        } else {
            this.log.warning("Unknown target VM " + targetVM + " ignored.");
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        }
    }

    @Override
    public void saveClassFile(String className, String classFileName) {
    }

    @Override
    public void doJavaFile(boolean keep) {
        if (!keep) {
            File javaFile = new File(this.javaFileName);
            javaFile.delete();
        }
    }

    @Override
    public JavacErrorDetail[] compile(final String targetClassName, final Node.Nodes pageNodes) throws JasperException {
        final String sourceFile = this.ctxt.getServletJavaFileName();
        final String outputDir = this.ctxt.getOptions().getScratchDir().getAbsolutePath();
        String packageName = this.ctxt.getServletPackageName();
        final ClassLoader classLoader = this.ctxt.getJspLoader();
        String[] fileNames = new String[]{sourceFile};
        String[] classNames = new String[]{targetClassName};
        final ArrayList problemList = new ArrayList();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result = result + sep;
                    result = result + new String(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result = result + sep;
                    result = result + new String(packageName[i]);
                    sep = ".";
                }
                result = result + sep;
                result = result + new String(typeName);
                return this.findType(result);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NameEnvironmentAnswer findType(String className) {
                block17: {
                    block18: {
                        block16: {
                            is = null;
                            try {
                                try {
                                    if (className.equals(targetClassName)) {
                                        compilationUnit = new CompilationUnit(sourceFile, className);
                                        var4_7 = new NameEnvironmentAnswer(compilationUnit, null);
                                        var12_9 = null;
                                        if (is == null) return var4_7;
                                        break block16;
                                    }
                                    resourceName = className.replace('.', '/') + ".class";
                                    is = classLoader.getResourceAsStream(resourceName);
                                    if (is == null) break block17;
                                    buf = new byte[8192];
                                    baos = new ByteArrayOutputStream(buf.length);
                                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                                        baos.write(buf, 0, count);
                                    }
                                    baos.flush();
                                    classBytes = baos.toByteArray();
                                    fileName = className.toCharArray();
                                    classFileReader = new ClassFileReader(classBytes, fileName, true);
                                    var10_26 = new NameEnvironmentAnswer(classFileReader, null);
                                    break block18;
                                }
                                catch (IOException exc) {
                                    JDTJavaCompiler.access$100(JDTJavaCompiler.this).log(Level.SEVERE, "Compilation error", exc);
                                    var12_12 = null;
                                    if (is == null) return null;
                                    try {
                                        is.close();
                                        return null;
                                    }
                                    catch (IOException exc) {
                                        return null;
                                    }
                                }
                                catch (ClassFormatException exc) {
                                    JDTJavaCompiler.access$100(JDTJavaCompiler.this).log(Level.SEVERE, "Compilation error", exc);
                                    var12_13 = null;
                                    if (is == null) return null;
                                    try {}
                                    catch (IOException exc) {
                                        return null;
                                    }
                                    is.close();
                                    return null;
                                }
                            }
                            catch (Throwable var11_27) {
                                var12_14 = null;
                                if (is == null) throw var11_27;
                                ** try [egrp 2[TRYBLOCK] [10 : 251->258)] { 
lbl51:
                                // 1 sources

                                is.close();
                                throw var11_27;
lbl53:
                                // 1 sources

                                catch (IOException exc) {
                                    // empty catch block
                                }
                                throw var11_27;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [10 : 251->258)] { 
lbl58:
                        // 1 sources

                        is.close();
                        return var4_7;
lbl60:
                        // 1 sources

                        catch (IOException exc) {
                            // empty catch block
                        }
                        return var4_7;
                    }
                    var12_10 = null;
                    if (is == null) return var10_26;
                    try {}
                    catch (IOException exc) {
                        // empty catch block
                        return var10_26;
                    }
                    is.close();
                    return var10_26;
                }
                var12_11 = null;
                if (is == null) return null;
                try {}
                catch (IOException exc) {}
                is.close();
                return null;
                return null;
            }

            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                String result = "";
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result = result + sep;
                        String str2 = new String(parentPackageName[i]);
                        result = result + str2;
                        sep = ".";
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                    return false;
                }
                result = result + sep;
                result = result + str;
                return this.isPackage(result);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        if (this.ctxt.getOptions().getJavaEncoding() != null) {
            this.settings.put("org.eclipse.jdt.core.encoding", this.ctxt.getOptions().getJavaEncoding());
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    int i;
                    if (result.hasProblems()) {
                        IProblem[] problems = JDTJavaCompiler.safeGetProblems(result);
                        for (i = 0; i < problems.length; ++i) {
                            IProblem problem = problems[i];
                            if (!problem.isError()) continue;
                            String name = new String(problems[i].getOriginatingFileName());
                            try {
                                problemList.add(ErrorDispatcher.createJavacError(name, pageNodes, new StringBuilder(problem.getMessage()), problem.getSourceLineNumber()));
                                continue;
                            }
                            catch (JasperException e) {
                                JDTJavaCompiler.this.log.log(Level.SEVERE, "Error visiting node", e);
                            }
                        }
                    }
                    if (problemList.isEmpty()) {
                        ClassFile[] classFiles = result.getClassFiles();
                        for (i = 0; i < classFiles.length; ++i) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            String className = "";
                            String sep = "";
                            for (int j = 0; j < compoundName.length; ++j) {
                                className = className + sep;
                                className = className + new String(compoundName[j]);
                                sep = ".";
                            }
                            byte[] bytes = classFile.getBytes();
                            String outFile = outputDir + "/" + className.replace('.', '/') + ".class";
                            FileOutputStream fout = new FileOutputStream(outFile);
                            BufferedOutputStream bos = new BufferedOutputStream(fout);
                            bos.write(bytes);
                            bos.close();
                        }
                    }
                }
                catch (IOException exc) {
                    JDTJavaCompiler.this.log.log(Level.SEVERE, "Compilation error", exc);
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            class CompilationUnit
            implements ICompilationUnit {
                String className;
                String sourceFile;

                CompilationUnit(String sourceFile, String className) {
                    this.className = className;
                    this.sourceFile = sourceFile;
                }

                public char[] getFileName() {
                    return this.className.toCharArray();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public char[] getContents() {
                    Reader reader;
                    char[] result;
                    block9: {
                        int count;
                        result = null;
                        reader = null;
                        InputStreamReader isReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), JDTJavaCompiler.this.ctxt.getOptions().getJavaEncoding());
                        reader = new BufferedReader(isReader);
                        if (reader == null) break block9;
                        char[] chars = new char[8192];
                        StringBuilder buf = new StringBuilder();
                        while ((count = reader.read(chars, 0, chars.length)) > 0) {
                            buf.append(chars, 0, count);
                        }
                        result = new char[buf.length()];
                        buf.getChars(0, result.length, result, 0);
                    }
                    Object var8_8 = null;
                    if (reader == null) return result;
                    try {
                        reader.close();
                        return result;
                    }
                    catch (IOException ioe) {}
                    return result;
                    {
                        catch (IOException e) {
                            JDTJavaCompiler.this.log.log(Level.SEVERE, "Compilation error", e);
                            Object var8_9 = null;
                            if (reader == null) return result;
                            try {
                                reader.close();
                                return result;
                            }
                            catch (IOException ioe) {}
                            return result;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (reader == null) throw throwable;
                        try {
                            reader.close();
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }

                public char[] getMainTypeName() {
                    int dot = this.className.lastIndexOf(46);
                    if (dot > 0) {
                        return this.className.substring(dot + 1).toCharArray();
                    }
                    return this.className.toCharArray();
                }

                public char[][] getPackageName() {
                    StringTokenizer izer = new StringTokenizer(this.className, ".");
                    char[][] result = new char[izer.countTokens() - 1][];
                    for (int i = 0; i < result.length; ++i) {
                        String tok = izer.nextToken();
                        result[i] = tok.toCharArray();
                    }
                    return result;
                }
            }
            compilationUnits[i] = new CompilationUnit(fileNames[i], classNames[i]);
        }
        Compiler compiler = new Compiler(env, policy, this.settings, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (problemList.isEmpty()) {
            return null;
        }
        return problemList.toArray(new JavacErrorDetail[0]);
    }

    private static final IProblem[] safeGetProblems(CompilationResult result) {
        if (!USE_INTROSPECTION_TO_INVOKE_GET_PROBLEM) {
            try {
                return result.getProblems();
            }
            catch (NoSuchMethodError re) {
                USE_INTROSPECTION_TO_INVOKE_GET_PROBLEM = true;
            }
        }
        try {
            if (GET_PROBLEM_METH == null) {
                GET_PROBLEM_METH = result.getClass().getDeclaredMethod("getProblems", new Class[0]);
            }
            return (IProblem[])GET_PROBLEM_METH.invoke((Object)result, null);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

