/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AptSourceLocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class AnnotationDiscoveryVisitor
extends ASTVisitor {
    final BaseProcessingEnvImpl _env;
    final Factory _factory;
    final ManyToMany<TypeElement, Element> _annoToElement;

    public AnnotationDiscoveryVisitor(BaseProcessingEnvImpl env) {
        this._env = env;
        this._factory = env.getFactory();
        this._annoToElement = new ManyToMany();
    }

    public boolean visit(Argument argument, BlockScope scope) {
        Annotation[] annotations = argument.annotations;
        ReferenceContext referenceContext = scope.referenceContext();
        if (referenceContext instanceof AbstractMethodDeclaration) {
            MethodBinding binding = ((AbstractMethodDeclaration)referenceContext).binding;
            if (binding != null) {
                TypeDeclaration typeDeclaration = scope.referenceType();
                typeDeclaration.binding.resolveTypesFor(binding);
                if (argument.binding != null) {
                    argument.binding = new AptSourceLocalVariableBinding(argument.binding, binding);
                }
            }
            if (annotations != null) {
                this.resolveAnnotations(scope, annotations, argument.binding);
            }
        }
        return false;
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        Argument[] arguments;
        Annotation[] annotations = constructorDeclaration.annotations;
        if (annotations != null) {
            MethodBinding constructorBinding = constructorDeclaration.binding;
            if (constructorBinding == null) {
                return false;
            }
            ((SourceTypeBinding)constructorBinding.declaringClass).resolveTypesFor(constructorBinding);
            this.resolveAnnotations(constructorDeclaration.scope, annotations, constructorBinding);
        }
        if ((arguments = constructorDeclaration.arguments) != null) {
            int argumentLength = arguments.length;
            for (int i = 0; i < argumentLength; ++i) {
                arguments[i].traverse((ASTVisitor)this, constructorDeclaration.scope);
            }
        }
        return false;
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        Annotation[] annotations = fieldDeclaration.annotations;
        if (annotations != null) {
            FieldBinding fieldBinding = fieldDeclaration.binding;
            if (fieldBinding == null) {
                return false;
            }
            ((SourceTypeBinding)fieldBinding.declaringClass).resolveTypeFor(fieldBinding);
            this.resolveAnnotations(scope, annotations, fieldBinding);
        }
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        Argument[] arguments;
        Annotation[] annotations = methodDeclaration.annotations;
        if (annotations != null) {
            MethodBinding methodBinding = methodDeclaration.binding;
            if (methodBinding == null) {
                return false;
            }
            ((SourceTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
            this.resolveAnnotations(methodDeclaration.scope, annotations, methodDeclaration.binding);
        }
        if ((arguments = methodDeclaration.arguments) != null) {
            int argumentLength = arguments.length;
            for (int i = 0; i < argumentLength; ++i) {
                arguments[i].traverse((ASTVisitor)this, methodDeclaration.scope);
            }
        }
        return false;
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        SourceTypeBinding binding = memberTypeDeclaration.binding;
        if (binding == null) {
            return false;
        }
        Annotation[] annotations = memberTypeDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(memberTypeDeclaration.staticInitializerScope, annotations, binding);
        }
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        SourceTypeBinding binding = typeDeclaration.binding;
        if (binding == null) {
            return false;
        }
        Annotation[] annotations = typeDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(typeDeclaration.staticInitializerScope, annotations, binding);
        }
        return true;
    }

    private void resolveAnnotations(BlockScope scope, Annotation[] annotations, Binding currentBinding) {
        ASTNode.resolveAnnotations(scope, annotations, currentBinding);
        for (Annotation annotation : annotations) {
            AnnotationBinding binding = annotation.getCompilerAnnotation();
            if (binding == null) continue;
            TypeElement anno = (TypeElement)this._factory.newElement(binding.getAnnotationType());
            Element element = this._factory.newElement(currentBinding);
            this._annoToElement.put(anno, element);
        }
    }
}

