/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class BatchAnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private List<Processor> _setProcessors = null;
    private Iterator<Processor> _setProcessorIter = null;
    private List<String> _commandLineProcessors;
    private Iterator<String> _commandLineProcessorIter = null;
    private ServiceLoader<Processor> _serviceLoader = null;
    private Iterator<Processor> _serviceLoaderIter;
    private ClassLoader _procLoader;
    private static final boolean VERBOSE_PROCESSOR_DISCOVERY = true;
    private boolean _printProcessorDiscovery = false;

    public void configure(Object batchCompiler, String[] commandLineArguments) {
        if (null != this._processingEnv) {
            throw new IllegalStateException("Calling configure() more than once on an AnnotationProcessorManager is not supported");
        }
        BatchProcessingEnvImpl processingEnv = new BatchProcessingEnvImpl(this, (Main)batchCompiler, commandLineArguments);
        this._processingEnv = processingEnv;
        this._procLoader = processingEnv.getFileManager().getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        this.parseCommandLine(commandLineArguments);
        this._round = 0;
    }

    private void parseCommandLine(String[] commandLineArguments) {
        ArrayList<String> commandLineProcessors = null;
        for (int i = 0; i < commandLineArguments.length; ++i) {
            String option = commandLineArguments[i];
            if ("-XprintProcessorInfo".equals(option)) {
                this._printProcessorInfo = true;
                this._printProcessorDiscovery = true;
                continue;
            }
            if ("-XprintRounds".equals(option)) {
                this._printRounds = true;
                continue;
            }
            if (!"-processor".equals(option)) continue;
            commandLineProcessors = new ArrayList<String>();
            String procs = commandLineArguments[++i];
            for (String proc : procs.split(",")) {
                commandLineProcessors.add(proc);
            }
            break;
        }
        this._commandLineProcessors = commandLineProcessors;
        if (null != this._commandLineProcessors) {
            this._commandLineProcessorIter = this._commandLineProcessors.iterator();
        }
    }

    public ProcessorInfo discoverNextProcessor() {
        if (null != this._setProcessors) {
            if (this._setProcessorIter.hasNext()) {
                Processor p = this._setProcessorIter.next();
                p.init(this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p);
                this._processors.add(pi);
                if (this._printProcessorDiscovery && null != this._out) {
                    this._out.println("API specified processor: " + pi);
                }
                return pi;
            }
            return null;
        }
        if (null != this._commandLineProcessors) {
            if (this._commandLineProcessorIter.hasNext()) {
                String proc = this._commandLineProcessorIter.next();
                try {
                    Class<?> clazz = this._procLoader.loadClass(proc);
                    Object o = clazz.newInstance();
                    Processor p = (Processor)o;
                    p.init(this._processingEnv);
                    ProcessorInfo pi = new ProcessorInfo(p);
                    this._processors.add(pi);
                    if (this._printProcessorDiscovery && null != this._out) {
                        this._out.println("Command line specified processor: " + pi);
                    }
                    return pi;
                }
                catch (Exception e) {
                    throw new AbortCompilation(null, (Throwable)e);
                }
            }
            return null;
        }
        if (null == this._serviceLoader) {
            this._serviceLoader = ServiceLoader.load(Processor.class, this._procLoader);
            this._serviceLoaderIter = this._serviceLoader.iterator();
        }
        try {
            if (this._serviceLoaderIter.hasNext()) {
                Processor p = this._serviceLoaderIter.next();
                p.init(this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p);
                this._processors.add(pi);
                if (this._printProcessorDiscovery && null != this._out) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Discovered processor service ");
                    sb.append(pi);
                    sb.append("\n  supporting ");
                    sb.append(pi.getSupportedAnnotationTypesAsString());
                    sb.append("\n  in ");
                    sb.append(this.getProcessorLocation(p));
                    this._out.println(sb.toString());
                }
                return pi;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new AbortCompilation(null, (Throwable)e);
        }
        return null;
    }

    private String getProcessorLocation(Processor p) {
        String location;
        boolean isMember = false;
        Class<?> outerClass = p.getClass();
        StringBuilder innerName = new StringBuilder();
        while (outerClass.isMemberClass()) {
            innerName.insert(0, outerClass.getSimpleName());
            innerName.insert(0, '$');
            isMember = true;
            outerClass = outerClass.getEnclosingClass();
        }
        String path = outerClass.getName();
        path = path.replace('.', '/');
        if (isMember) {
            path = path + innerName;
        }
        if ((location = this._procLoader.getResource(path = path + ".class").toString()).endsWith(path)) {
            location = location.substring(0, location.length() - path.length());
        }
        return location;
    }

    public void reportProcessorException(Processor p, Exception e) {
        throw new AbortCompilation(null, (Throwable)e);
    }

    public void setProcessors(Object[] processors) {
        if (!this._isFirstRound) {
            throw new IllegalStateException("setProcessors() cannot be called after processing has begun");
        }
        this._setProcessors = new ArrayList<Processor>(processors.length);
        for (Object o : processors) {
            Processor p = (Processor)o;
            this._setProcessors.add(p);
        }
        this._setProcessorIter = this._setProcessors.iterator();
        this._commandLineProcessors = null;
        this._commandLineProcessorIter = null;
    }
}

