/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal {
    char[] source;
    int lineNumber;

    public StringLiteral(char[] token, int start, int end, int lineNumber) {
        this(start, end);
        this.source = token;
        this.lineNumber = lineNumber - 1;
    }

    public StringLiteral(int s, int e) {
        super(s, e);
    }

    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(CharLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral lit) {
        return new StringLiteralConcatenation(this, lit);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope scope) {
        return scope.getJavaLangString();
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('\"');
        block10: for (int i = 0; i < this.source.length; ++i) {
            switch (this.source[i]) {
                case '\b': {
                    output.append("\\b");
                    continue block10;
                }
                case '\t': {
                    output.append("\\t");
                    continue block10;
                }
                case '\n': {
                    output.append("\\n");
                    continue block10;
                }
                case '\f': {
                    output.append("\\f");
                    continue block10;
                }
                case '\r': {
                    output.append("\\r");
                    continue block10;
                }
                case '\"': {
                    output.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    output.append("\\'");
                    continue block10;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block10;
                }
                default: {
                    output.append(this.source[i]);
                }
            }
        }
        output.append('\"');
        return output;
    }

    public char[] source() {
        return this.source;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

