/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment environment) {
        super(environment);
    }

    boolean areMethodsCompatible(MethodBinding one, MethodBinding two) {
        two = (one = one.original()).findOriginalInheritedMethod(two);
        if (two == null) {
            return false;
        }
        return this.isParameterSubsignature(one, two);
    }

    boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        int i;
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        for (i = 0; i < length; ++i) {
            if (this.areTypesEqual(oneArgs[i], twoArgs[i])) continue;
            if (oneArgs[i].leafComponentType().isRawType() && oneArgs[i].dimensions() == twoArgs[i].dimensions() && oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType())) {
                if (one.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    return false;
                }
                for (int j = 0; j < i; ++j) {
                    if (!oneArgs[j].leafComponentType().isParameterizedTypeWithActualArguments()) continue;
                    return false;
                }
                break;
            }
            return false;
        }
        ++i;
        while (i < length) {
            if (!this.areTypesEqual(oneArgs[i], twoArgs[i])) {
                if (!oneArgs[i].leafComponentType().isRawType() || oneArgs[i].dimensions() != twoArgs[i].dimensions() || !oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType())) {
                    return false;
                }
            } else if (oneArgs[i].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean areReturnTypesCompatible(MethodBinding one, MethodBinding two) {
        if (one.returnType == two.returnType) {
            return true;
        }
        if (this.type.scope.compilerOptions().sourceLevel >= 0x310000L) {
            return this.areReturnTypesCompatible0(one, two);
        }
        return this.areTypesEqual(one.returnType.erasure(), two.returnType.erasure());
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        block0 : switch (one.kind()) {
            case 4: {
                switch (two.kind()) {
                    case 260: 
                    case 1028: {
                        if (one == two.erasure()) {
                            return true;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (two.kind()) {
                    case 4: {
                        if (one.erasure() != two) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (!one.isParameterizedType()) return false;
        if (!two.isParameterizedType()) return false;
        if (!one.isEquivalentTo(two)) return false;
        if (!two.isEquivalentTo(one)) return false;
        return true;
    }

    protected boolean canOverridingMethodDifferInErasure(MethodBinding overridingMethod, MethodBinding inheritedMethod) {
        if (overridingMethod.areParameterErasuresEqual(inheritedMethod)) {
            return false;
        }
        return !overridingMethod.declaringClass.isRawType();
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding one, MethodBinding two) {
        return two == null || one.declaringClass == two.declaringClass && !one.declaringClass.isParameterizedType();
    }

    void checkConcreteInheritedMethod(MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        super.checkConcreteInheritedMethod(concreteMethod, abstractMethods);
        for (MethodBinding abstractMethod : abstractMethods) {
            if (concreteMethod.isVarargs() != abstractMethod.isVarargs()) {
                this.problemReporter().varargsConflict(concreteMethod, abstractMethod, this.type);
            }
            MethodBinding originalInherited = abstractMethod.original();
            if (originalInherited.returnType != concreteMethod.returnType && !this.isAcceptableReturnTypeOverride(concreteMethod, abstractMethod)) {
                this.problemReporter().unsafeReturnTypeOverride(concreteMethod, originalInherited, this.type);
            }
            if (!originalInherited.declaringClass.isInterface() || (concreteMethod.declaringClass != this.type.superclass || !this.type.superclass.isParameterizedType() || this.areMethodsCompatible(concreteMethod, originalInherited)) && this.type.superclass.erasure().findSuperTypeOriginatingFrom(originalInherited.declaringClass) != null) continue;
            this.type.addSyntheticBridgeMethod(originalInherited, concreteMethod.original());
        }
    }

    void checkForBridgeMethod(MethodBinding currentMethod, MethodBinding inheritedMethod, MethodBinding[] allInheritedMethods) {
        SyntheticMethodBinding bridge;
        if (currentMethod.isVarargs() != inheritedMethod.isVarargs()) {
            this.problemReporter(currentMethod).varargsConflict(currentMethod, inheritedMethod, this.type);
        }
        MethodBinding originalInherited = inheritedMethod.original();
        if (originalInherited.returnType != currentMethod.returnType && !this.isAcceptableReturnTypeOverride(currentMethod, inheritedMethod)) {
            this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, originalInherited, this.type);
        }
        if ((bridge = this.type.addSyntheticBridgeMethod(originalInherited, currentMethod.original())) != null) {
            int l;
            int n = l = allInheritedMethods == null ? 0 : allInheritedMethods.length;
            for (int i = 0; i < l; ++i) {
                if (allInheritedMethods[i] == null || !this.detectInheritedNameClash(originalInherited, allInheritedMethods[i].original())) continue;
                return;
            }
            MethodBinding[] current = (MethodBinding[])this.currentMethods.get(bridge.selector);
            for (int i = current.length - 1; i >= 0; --i) {
                MethodBinding thisMethod = current[i];
                if (!thisMethod.areParameterErasuresEqual(bridge) || thisMethod.returnType.erasure() != bridge.returnType.erasure()) continue;
                this.problemReporter(thisMethod).methodNameClash(thisMethod, inheritedMethod.declaringClass.isRawType() ? inheritedMethod : inheritedMethod.original(), 1);
                return;
            }
        }
    }

    void checkForNameClash(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.isStatic()) {
            return;
        }
        if (!this.detectNameClash(currentMethod, inheritedMethod, false)) {
            TypeBinding[] currentParams = currentMethod.parameters;
            int length = currentParams.length;
            TypeBinding[] inheritedParams = inheritedMethod.parameters;
            if (length != inheritedParams.length) {
                return;
            }
            for (int i = 0; i < length; ++i) {
                if (currentParams[i] == inheritedParams[i] || currentParams[i].isBaseType() == inheritedParams[i].isBaseType() && inheritedParams[i].isCompatibleWith(currentParams[i])) continue;
                return;
            }
            ReferenceBinding[] interfacesToVisit = null;
            int nextPosition = 0;
            ReferenceBinding superType = inheritedMethod.declaringClass;
            ReferenceBinding[] itsInterfaces = superType.superInterfaces();
            if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
                nextPosition = itsInterfaces.length;
                interfacesToVisit = itsInterfaces;
            }
            for (superType = superType.superclass(); superType != null && superType.isValidBinding(); superType = superType.superclass()) {
                MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                int n = methods.length;
                for (int m = 0; m < n; ++m) {
                    MethodBinding substitute = this.computeSubstituteMethod(methods[m], currentMethod);
                    if (substitute == null || this.isSubstituteParameterSubsignature(currentMethod, substitute) || !this.detectNameClash(currentMethod, substitute, true)) continue;
                    return;
                }
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                if (interfacesToVisit == null) {
                    interfacesToVisit = itsInterfaces;
                    nextPosition = interfacesToVisit.length;
                    continue;
                }
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block3: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (next == interfacesToVisit[b]) continue block3;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
            for (int i = 0; i < nextPosition; ++i) {
                superType = interfacesToVisit[i];
                if (!superType.isValidBinding()) continue;
                MethodBinding[] methods = superType.getMethods(currentMethod.selector);
                int n = methods.length;
                for (int m = 0; m < n; ++m) {
                    MethodBinding substitute = this.computeSubstituteMethod(methods[m], currentMethod);
                    if (substitute == null || this.isSubstituteParameterSubsignature(currentMethod, substitute) || !this.detectNameClash(currentMethod, substitute, true)) continue;
                    return;
                }
                itsInterfaces = superType.superInterfaces();
                if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
                int itsLength = itsInterfaces.length;
                if (nextPosition + itsLength >= interfacesToVisit.length) {
                    ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                }
                block7: for (int a = 0; a < itsLength; ++a) {
                    ReferenceBinding next = itsInterfaces[a];
                    for (int b = 0; b < nextPosition; ++b) {
                        if (next == interfacesToVisit[b]) continue block7;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
            }
        }
    }

    void checkInheritedMethods(MethodBinding inheritedMethod, MethodBinding otherInheritedMethod) {
        if (inheritedMethod.declaringClass.isInterface() || inheritedMethod.isStatic()) {
            return;
        }
        this.detectInheritedNameClash(inheritedMethod.original(), otherInheritedMethod.original());
    }

    void checkInheritedMethods(MethodBinding[] methods, int length) {
        boolean continueInvestigation = true;
        MethodBinding concreteMethod = null;
        for (int i = 0; i < length; ++i) {
            if (methods[i].isAbstract()) continue;
            if (concreteMethod != null) {
                this.problemReporter().duplicateInheritedMethods(this.type, concreteMethod, methods[i]);
                continueInvestigation = false;
            }
            concreteMethod = methods[i];
        }
        if (continueInvestigation) {
            super.checkInheritedMethods(methods, length);
        }
    }

    boolean checkInheritedReturnTypes(MethodBinding method, MethodBinding otherMethod) {
        if (this.areReturnTypesCompatible(method, otherMethod)) {
            return true;
        }
        if (this.isUnsafeReturnTypeOverride(method, otherMethod)) {
            if (!method.declaringClass.implementsInterface(otherMethod.declaringClass, false)) {
                this.problemReporter(method).unsafeReturnTypeOverride(method, otherMethod, this.type);
            }
            return true;
        }
        return false;
    }

    void reportRawReferences() {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        Object[] methodArray = this.currentMethods.valueTable;
        int s = methodArray.length;
        while (--s >= 0) {
            if (methodArray[s] == null) continue;
            for (MethodBinding currentMethod : (MethodBinding[])methodArray[s]) {
                if ((currentMethod.modifiers & 0x30000000) != 0) continue;
                AbstractMethodDeclaration methodDecl = currentMethod.sourceMethod();
                if (methodDecl == null) {
                    return;
                }
                TypeBinding[] parameterTypes = currentMethod.parameters;
                Argument[] arguments = methodDecl.arguments;
                int size = currentMethod.parameters.length;
                for (int j = 0; j < size; ++j) {
                    TypeBinding parameterType = parameterTypes[j];
                    Argument arg = arguments[j];
                    if (!parameterType.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (arg.type.bits & 0x40000000) != 0) continue;
                    methodDecl.scope.problemReporter().rawTypeReference(arg.type, parameterType);
                }
                if (methodDecl.isConstructor() || !(methodDecl instanceof MethodDeclaration)) continue;
                TypeReference returnType = ((MethodDeclaration)methodDecl).returnType;
                TypeBinding methodType = currentMethod.returnType;
                if (returnType == null || !methodType.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (returnType.bits & 0x40000000) != 0) continue;
                methodDecl.scope.problemReporter().rawTypeReference(returnType, methodType);
            }
        }
    }

    public void reportRawReferences(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        AbstractMethodDeclaration methodDecl = currentMethod.sourceMethod();
        if (methodDecl == null) {
            return;
        }
        TypeBinding[] parameterTypes = currentMethod.parameters;
        TypeBinding[] inheritedParameterTypes = inheritedMethod.parameters;
        Argument[] arguments = methodDecl.arguments;
        int size = currentMethod.parameters.length;
        for (int j = 0; j < size; ++j) {
            TypeBinding parameterType = parameterTypes[j];
            TypeBinding inheritedParameterType = inheritedParameterTypes[j];
            Argument arg = arguments[j];
            if (!parameterType.leafComponentType().isRawType()) continue;
            if (inheritedParameterType.leafComponentType().isRawType()) {
                arg.binding.tagBits |= 0x200L;
                continue;
            }
            if (compilerOptions.getSeverity(0x20010000) == 256 || (arg.type.bits & 0x40000000) != 0) continue;
            methodDecl.scope.problemReporter().rawTypeReference(arg.type, parameterType);
        }
        TypeReference returnType = null;
        if (!methodDecl.isConstructor() && methodDecl instanceof MethodDeclaration && (returnType = ((MethodDeclaration)methodDecl).returnType) != null) {
            TypeBinding inheritedMethodType = inheritedMethod.returnType;
            TypeBinding methodType = currentMethod.returnType;
            if (methodType.leafComponentType().isRawType() && !inheritedMethodType.leafComponentType().isRawType() && (returnType.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                methodDecl.scope.problemReporter().rawTypeReference(returnType, methodType);
            }
        }
    }

    void checkMethods() {
        boolean mustImplementAbstractMethods = this.mustImplementAbstractMethods();
        boolean skipInheritedMethods = mustImplementAbstractMethods && this.canSkipInheritedMethods();
        boolean isOrEnclosedByPrivateType = this.type.isOrEnclosedByPrivateType();
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        while (--s >= 0) {
            int j;
            int i;
            int length;
            if (methodSelectors[s] == null) continue;
            MethodBinding[] current = (MethodBinding[])this.currentMethods.get(methodSelectors[s]);
            MethodBinding[] inherited = (MethodBinding[])this.inheritedMethods.valueTable[s];
            if (current == null && !isOrEnclosedByPrivateType) {
                length = inherited.length;
                for (i = 0; i < length; ++i) {
                    inherited[i].original().modifiers |= 0x8000000;
                }
            }
            if (current == null && this.type.isPublic()) {
                length = inherited.length;
                for (i = 0; i < length; ++i) {
                    MethodBinding inheritedMethod = inherited[i];
                    if (!inheritedMethod.isPublic() || inheritedMethod.declaringClass.isPublic()) continue;
                    this.type.addSyntheticBridgeMethod(inheritedMethod.original());
                }
            }
            if (current == null && skipInheritedMethods) continue;
            if (inherited.length == 1 && current == null) {
                if (!mustImplementAbstractMethods || !inherited[0].isAbstract()) continue;
                this.checkAbstractMethod(inherited[0]);
                continue;
            }
            int index = -1;
            int inheritedLength = inherited.length;
            MethodBinding[] matchingInherited = new MethodBinding[inheritedLength];
            MethodBinding[] foundMatch = new MethodBinding[inheritedLength];
            if (current != null) {
                int length1 = current.length;
                for (int i2 = 0; i2 < length1; ++i2) {
                    MethodBinding currentMethod = current[i2];
                    MethodBinding[] nonMatchingInherited = null;
                    for (j = 0; j < inheritedLength; ++j) {
                        MethodBinding inheritedMethod = this.computeSubstituteMethod(inherited[j], currentMethod);
                        if (inheritedMethod == null) continue;
                        if (foundMatch[j] == null && this.isSubstituteParameterSubsignature(currentMethod, inheritedMethod)) {
                            matchingInherited[++index] = inheritedMethod;
                            foundMatch[j] = currentMethod;
                            continue;
                        }
                        this.checkForNameClash(currentMethod, inheritedMethod);
                        if (inheritedLength <= 1) continue;
                        if (nonMatchingInherited == null) {
                            nonMatchingInherited = new MethodBinding[inheritedLength];
                        }
                        nonMatchingInherited[j] = inheritedMethod;
                    }
                    if (index < 0) continue;
                    this.checkAgainstInheritedMethods(currentMethod, matchingInherited, index + 1, nonMatchingInherited);
                    while (index >= 0) {
                        matchingInherited[index--] = null;
                    }
                }
            }
            boolean[] skip = new boolean[inheritedLength];
            for (int i3 = 0; i3 < inheritedLength; ++i3) {
                MethodBinding inheritedMethod;
                MethodBinding matchMethod = foundMatch[i3];
                if (matchMethod == null && current != null && this.type.isPublic() && (inheritedMethod = inherited[i3]).isPublic() && !inheritedMethod.declaringClass.isPublic()) {
                    this.type.addSyntheticBridgeMethod(inheritedMethod.original());
                }
                if (!isOrEnclosedByPrivateType && matchMethod == null && current != null) {
                    inherited[i3].original().modifiers |= 0x8000000;
                }
                if (skip[i3]) continue;
                inheritedMethod = inherited[i3];
                if (matchMethod == null) {
                    matchingInherited[++index] = inheritedMethod;
                }
                for (j = i3 + 1; j < inheritedLength; ++j) {
                    MethodBinding otherInheritedMethod = inherited[j];
                    if (matchMethod == foundMatch[j] && matchMethod != null || this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod)) continue;
                    if (inheritedMethod.declaringClass != otherInheritedMethod.declaringClass) {
                        if (otherInheritedMethod.declaringClass.isInterface()) {
                            if (this.isInterfaceMethodImplemented(otherInheritedMethod, inheritedMethod, otherInheritedMethod.declaringClass)) {
                                skip[j] = true;
                                continue;
                            }
                        } else if (this.areMethodsCompatible(inheritedMethod, otherInheritedMethod)) {
                            skip[j] = true;
                            continue;
                        }
                    }
                    if ((otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) == null) continue;
                    if (this.isSubstituteParameterSubsignature(inheritedMethod, otherInheritedMethod)) {
                        if (index == -1) {
                            matchingInherited[++index] = inheritedMethod;
                        }
                        if (foundMatch[j] == null) {
                            matchingInherited[++index] = otherInheritedMethod;
                        }
                        skip[j] = true;
                        continue;
                    }
                    if (matchMethod != null || foundMatch[j] != null) continue;
                    this.checkInheritedMethods(inheritedMethod, otherInheritedMethod);
                }
                if (index == -1) continue;
                if (index > 0) {
                    this.checkInheritedMethods(matchingInherited, index + 1);
                } else if (mustImplementAbstractMethods && matchingInherited[0].isAbstract() && matchMethod == null) {
                    this.checkAbstractMethod(matchingInherited[0]);
                }
                while (index >= 0) {
                    matchingInherited[index--] = null;
                }
            }
        }
    }

    void checkTypeVariableMethods(TypeParameter typeParameter) {
        char[][] methodSelectors = this.inheritedMethods.keyTable;
        int s = methodSelectors.length;
        block0: while (--s >= 0) {
            MethodBinding[] inherited;
            if (methodSelectors[s] == null || (inherited = (MethodBinding[])this.inheritedMethods.valueTable[s]).length == 1) continue;
            int index = -1;
            MethodBinding[] matchingInherited = new MethodBinding[inherited.length];
            int length = inherited.length;
            for (int i = 0; i < length; ++i) {
                while (index >= 0) {
                    matchingInherited[index--] = null;
                }
                MethodBinding inheritedMethod = inherited[i];
                if (inheritedMethod != null) {
                    matchingInherited[++index] = inheritedMethod;
                    for (int j = i + 1; j < length; ++j) {
                        MethodBinding otherInheritedMethod = inherited[j];
                        if (this.canSkipInheritedMethods(inheritedMethod, otherInheritedMethod) || (otherInheritedMethod = this.computeSubstituteMethod(otherInheritedMethod, inheritedMethod)) == null || !this.isSubstituteParameterSubsignature(inheritedMethod, otherInheritedMethod)) continue;
                        matchingInherited[++index] = otherInheritedMethod;
                        inherited[j] = null;
                    }
                }
                if (index <= 0) continue;
                MethodBinding first = matchingInherited[0];
                int count = index + 1;
                while (--count > 0) {
                    MethodBinding match = matchingInherited[count];
                    MethodBinding interfaceMethod = null;
                    MethodBinding implementation = null;
                    if (first.declaringClass.isInterface()) {
                        interfaceMethod = first;
                    } else if (first.declaringClass.isClass()) {
                        implementation = first;
                    }
                    if (match.declaringClass.isInterface()) {
                        interfaceMethod = match;
                    } else if (match.declaringClass.isClass()) {
                        implementation = match;
                    }
                    if (interfaceMethod != null && implementation != null && !this.isAsVisible(implementation, interfaceMethod)) {
                        this.problemReporter().inheritedMethodReducesVisibility(typeParameter, implementation, new MethodBinding[]{interfaceMethod});
                    }
                    if (this.areReturnTypesCompatible(first, match) || first.declaringClass.isInterface() && match.declaringClass.isInterface() && this.areReturnTypesCompatible(match, first)) continue;
                }
                if (count <= 0) continue;
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(typeParameter, matchingInherited, index + 1);
                continue block0;
            }
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding inheritedMethod, MethodBinding currentMethod) {
        TypeVariableBinding[] inheritedTypeVariables;
        int inheritedLength;
        if (inheritedMethod == null) {
            return null;
        }
        if (currentMethod.parameters.length != inheritedMethod.parameters.length) {
            return null;
        }
        if (currentMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)currentMethod.declaringClass).resolveTypesFor(currentMethod);
        }
        if (inheritedMethod.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)inheritedMethod.declaringClass).resolveTypesFor(inheritedMethod);
        }
        if ((inheritedLength = (inheritedTypeVariables = inheritedMethod.typeVariables).length) == 0) {
            return inheritedMethod;
        }
        TypeVariableBinding[] typeVariables = currentMethod.typeVariables;
        int length = typeVariables.length;
        if (length == 0) {
            return inheritedMethod.asRawMethod(this.environment);
        }
        if (length != inheritedLength) {
            return inheritedMethod;
        }
        TypeBinding[] arguments = new TypeBinding[length];
        System.arraycopy(typeVariables, 0, arguments, 0, length);
        ParameterizedGenericMethodBinding substitute = this.environment.createParameterizedGenericMethod(inheritedMethod, arguments);
        for (int i = 0; i < inheritedLength; ++i) {
            TypeVariableBinding inheritedTypeVariable = inheritedTypeVariables[i];
            TypeBinding argument = arguments[i];
            if (argument instanceof TypeVariableBinding) {
                TypeVariableBinding typeVariable = (TypeVariableBinding)argument;
                if (typeVariable.firstBound == inheritedTypeVariable.firstBound) {
                    if (typeVariable.firstBound == null) {
                        continue;
                    }
                } else if (typeVariable.firstBound != null && inheritedTypeVariable.firstBound != null && typeVariable.firstBound.isClass() != inheritedTypeVariable.firstBound.isClass()) {
                    return inheritedMethod;
                }
                if (Scope.substitute((Substitution)substitute, inheritedTypeVariable.superclass) != typeVariable.superclass) {
                    return inheritedMethod;
                }
                int interfaceLength = inheritedTypeVariable.superInterfaces.length;
                ReferenceBinding[] interfaces = typeVariable.superInterfaces;
                if (interfaceLength != interfaces.length) {
                    return inheritedMethod;
                }
                block1: for (int j = 0; j < interfaceLength; ++j) {
                    TypeBinding superType = Scope.substitute((Substitution)substitute, inheritedTypeVariable.superInterfaces[j]);
                    for (int k = 0; k < interfaceLength; ++k) {
                        if (superType == interfaces[k]) continue block1;
                    }
                    return inheritedMethod;
                }
                continue;
            }
            if (inheritedTypeVariable.boundCheck(substitute, argument) == 0) continue;
            return inheritedMethod;
        }
        return substitute;
    }

    boolean detectInheritedNameClash(MethodBinding inherited, MethodBinding otherInherited) {
        if (!inherited.areParameterErasuresEqual(otherInherited)) {
            return false;
        }
        if (inherited.returnType.erasure() != otherInherited.returnType.erasure()) {
            return false;
        }
        if (inherited.declaringClass.erasure() != otherInherited.declaringClass.erasure()) {
            if (inherited.declaringClass.findSuperTypeOriginatingFrom(otherInherited.declaringClass) != null) {
                return false;
            }
            if (otherInherited.declaringClass.findSuperTypeOriginatingFrom(inherited.declaringClass) != null) {
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, inherited, otherInherited);
        return true;
    }

    boolean detectNameClash(MethodBinding current, MethodBinding inherited, boolean treatAsSynthetic) {
        MethodBinding[] currentNamesakes;
        MethodBinding methodToCheck = inherited;
        MethodBinding original = methodToCheck.original();
        if (!current.areParameterErasuresEqual(original)) {
            return false;
        }
        int severity = 1;
        if (this.environment.globalOptions.complianceLevel == 0x320000L && current.returnType.erasure() != original.returnType.erasure()) {
            severity = 0;
        }
        if (!treatAsSynthetic && (currentNamesakes = (MethodBinding[])this.currentMethods.get(inherited.selector)).length > 1) {
            for (MethodBinding currentMethod : currentNamesakes) {
                if (currentMethod == current || !this.doesMethodOverride(currentMethod, inherited)) continue;
                methodToCheck = currentMethod;
                break;
            }
        }
        if (!current.areParameterErasuresEqual(original = methodToCheck.original())) {
            return false;
        }
        original = inherited.original();
        this.problemReporter(current).methodNameClash(current, inherited.declaringClass.isRawType() ? inherited : original, severity);
        return severity != 0;
    }

    public boolean doesMethodOverride(MethodBinding method, MethodBinding inheritedMethod) {
        return this.couldMethodOverride(method, inheritedMethod) && this.areMethodsCompatible(method, inheritedMethod);
    }

    boolean doTypeVariablesClash(MethodBinding one, MethodBinding substituteTwo) {
        return one.typeVariables != Binding.NO_TYPE_VARIABLES && !(substituteTwo instanceof ParameterizedGenericMethodBinding);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding superclass, ReferenceBinding[] superInterfaces) {
        ReferenceBinding superType;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding[] itsInterfaces = superInterfaces;
        if (itsInterfaces != Binding.NO_SUPERINTERFACES) {
            nextPosition = itsInterfaces.length;
            interfacesToVisit = itsInterfaces;
        }
        boolean isInconsistent = this.type.isHierarchyInconsistent();
        for (superType = superclass; superType != null && superType.isValidBinding(); superType = superType.superclass()) {
            isInconsistent |= superType.isHierarchyInconsistent();
            itsInterfaces = superType.superInterfaces();
            if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block1: for (int a = 0; a < itsLength; ++a) {
                ReferenceBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (next == interfacesToVisit[b]) continue block1;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
        for (int i = 0; i < nextPosition; ++i) {
            superType = interfacesToVisit[i];
            if (!superType.isValidBinding()) continue;
            isInconsistent |= superType.isHierarchyInconsistent();
            itsInterfaces = superType.superInterfaces();
            if (itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block4: for (int a = 0; a < itsLength; ++a) {
                ReferenceBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (next == interfacesToVisit[b]) continue block4;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
        if (!isInconsistent) {
            return null;
        }
        SimpleSet copy = null;
        for (int i = 0; i < nextPosition; ++i) {
            ReferenceBinding current = interfacesToVisit[i];
            if (!current.isValidBinding()) continue;
            TypeBinding erasure = current.erasure();
            for (int j = i + 1; j < nextPosition; ++j) {
                ReferenceBinding next = interfacesToVisit[j];
                if (!next.isValidBinding() || next.erasure() != erasure) continue;
                if (copy == null) {
                    copy = new SimpleSet(nextPosition);
                }
                copy.add(interfacesToVisit[i]);
                copy.add(interfacesToVisit[j]);
            }
        }
        return copy;
    }

    boolean hasGenericParameter(MethodBinding method) {
        if (method.genericSignature() == null) {
            return false;
        }
        TypeBinding[] params = method.parameters;
        int l = params.length;
        for (int i = 0; i < l; ++i) {
            int modifiers;
            TypeBinding param = params[i].leafComponentType();
            if (!(param instanceof ReferenceBinding) || ((modifiers = ((ReferenceBinding)param).modifiers) & 0x40000000) == 0) continue;
            return true;
        }
        return false;
    }

    boolean isAcceptableReturnTypeOverride(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (inheritedMethod.declaringClass.isRawType()) {
            return true;
        }
        MethodBinding originalInherited = inheritedMethod.original();
        TypeBinding originalInheritedReturnType = originalInherited.returnType.leafComponentType();
        if (originalInheritedReturnType.isParameterizedTypeWithActualArguments()) {
            return !currentMethod.returnType.leafComponentType().isRawType();
        }
        TypeBinding currentReturnType = currentMethod.returnType.leafComponentType();
        switch (currentReturnType.kind()) {
            case 4100: {
                if (currentReturnType != inheritedMethod.returnType.leafComponentType()) break;
                return true;
            }
        }
        return !originalInheritedReturnType.isTypeVariable() || ((TypeVariableBinding)originalInheritedReturnType).declaringElement != originalInherited;
    }

    boolean isInterfaceMethodImplemented(MethodBinding inheritedMethod, MethodBinding existingMethod, ReferenceBinding superType) {
        if (inheritedMethod.original() != inheritedMethod && existingMethod.declaringClass.isInterface()) {
            return false;
        }
        return (inheritedMethod = this.computeSubstituteMethod(inheritedMethod, existingMethod)) != null && inheritedMethod.returnType == existingMethod.returnType && this.doesMethodOverride(existingMethod, inheritedMethod);
    }

    public boolean isMethodSubsignature(MethodBinding method, MethodBinding inheritedMethod) {
        MethodBinding inheritedOriginal;
        if (!CharOperation.equals(method.selector, inheritedMethod.selector)) {
            return false;
        }
        if (method.declaringClass.isParameterizedType()) {
            method = method.original();
        }
        return this.isParameterSubsignature(method, (inheritedOriginal = method.findOriginalInheritedMethod(inheritedMethod)) == null ? inheritedMethod : inheritedOriginal);
    }

    boolean isParameterSubsignature(MethodBinding method, MethodBinding inheritedMethod) {
        MethodBinding substitute = this.computeSubstituteMethod(inheritedMethod, method);
        return substitute != null && this.isSubstituteParameterSubsignature(method, substitute);
    }

    boolean isSubstituteParameterSubsignature(MethodBinding method, MethodBinding substituteMethod) {
        if (!this.areParametersEqual(method, substituteMethod)) {
            if (substituteMethod.hasSubstitutedParameters() && method.areParameterErasuresEqual(substituteMethod)) {
                return method.typeVariables == Binding.NO_TYPE_VARIABLES && !this.hasGenericParameter(method);
            }
            if (method.declaringClass.isRawType() && substituteMethod.declaringClass.isRawType() && method.hasSubstitutedParameters() && substituteMethod.hasSubstitutedParameters()) {
                return this.areMethodsCompatible(method, substituteMethod);
            }
            return false;
        }
        if (substituteMethod instanceof ParameterizedGenericMethodBinding) {
            if (method.typeVariables != Binding.NO_TYPE_VARIABLES) {
                return !((ParameterizedGenericMethodBinding)substituteMethod).isRaw;
            }
            return !this.hasGenericParameter(method);
        }
        return method.typeVariables == Binding.NO_TYPE_VARIABLES;
    }

    boolean isUnsafeReturnTypeOverride(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod.returnType == inheritedMethod.returnType.erasure()) {
            TypeBinding[] currentParams = currentMethod.parameters;
            TypeBinding[] inheritedParams = inheritedMethod.parameters;
            int l = currentParams.length;
            for (int i = 0; i < l; ++i) {
                if (this.areTypesEqual(currentParams[i], inheritedParams[i])) continue;
                return true;
            }
        }
        return currentMethod.typeVariables == Binding.NO_TYPE_VARIABLES && inheritedMethod.original().typeVariables != Binding.NO_TYPE_VARIABLES && currentMethod.returnType.erasure().findSuperTypeOriginatingFrom(inheritedMethod.returnType.erasure()) != null;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (this.isUnsafeReturnTypeOverride(currentMethod, inheritedMethod)) {
            this.problemReporter(currentMethod).unsafeReturnTypeOverride(currentMethod, inheritedMethod, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(currentMethod, inheritedMethod);
    }

    void verify() {
        if (this.type.isAnnotationType()) {
            this.type.detectAnnotationCycle();
        }
        super.verify();
        this.reportRawReferences();
        int i = this.type.typeVariables.length;
        while (--i >= 0) {
            TypeVariableBinding var = this.type.typeVariables[i];
            if (var.superInterfaces == Binding.NO_SUPERINTERFACES || var.superInterfaces.length == 1 && var.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding superclass = var.superclass();
            if (superclass.kind() == 4100) {
                superclass = (ReferenceBinding)superclass.erasure();
            }
            ReferenceBinding[] itsInterfaces = var.superInterfaces();
            ReferenceBinding[] superInterfaces = new ReferenceBinding[itsInterfaces.length];
            int j = itsInterfaces.length;
            while (--j >= 0) {
                superInterfaces[j] = itsInterfaces[j].kind() == 4100 ? (ReferenceBinding)itsInterfaces[j].erasure() : itsInterfaces[j];
            }
            this.computeInheritedMethods(superclass, superInterfaces);
            this.checkTypeVariableMethods(this.type.scope.referenceContext.typeParameters[i]);
        }
    }
}

