/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.WebServletAnnotation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServletAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(WebServletAnnotationHandler.class);

    public WebServletAnnotationHandler(WebAppContext context) {
        super(context);
    }

    public WebServletAnnotationHandler(WebAppContext context, List<DiscoveredAnnotation> list) {
        super(context, list);
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotationName, List<AnnotationParser.Value> values) {
        if (!"javax.servlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        WebServletAnnotation annotation = new WebServletAnnotation(this._context, className, this._resource);
        this.addAnnotation(annotation);
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        LOG.warn("@WebServlet annotation not supported for fields", new Object[0]);
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        LOG.warn("@WebServlet annotation not supported for methods", new Object[0]);
    }

    @Override
    public String getAnnotationName() {
        return "javax.servlet.annotation.WebServlet";
    }
}

