/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.graph;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.jetty.deploy.graph.Edge;
import org.eclipse.jetty.deploy.graph.Graph;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.util.IO;

public class GraphOutputDot {
    private static final String TOPNODE = "undeployed";

    private GraphOutputDot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Graph graph, File outputFile) throws IOException {
        FileWriter writer = null;
        PrintWriter out = null;
        try {
            writer = new FileWriter(outputFile);
            out = new PrintWriter(writer);
            out.println("// Autogenerated by " + GraphOutputDot.class.getName());
            out.println("digraph Graf {");
            GraphOutputDot.writeGraphDefaults(out);
            GraphOutputDot.writeNodeDefaults(out);
            GraphOutputDot.writeEdgeDefaults(out);
            TreeSet<Node> nodes = new TreeSet<Node>(new TopNodeSort());
            nodes.addAll(graph.getNodes());
            for (Node node : nodes) {
                GraphOutputDot.writeNode(out, node);
            }
            for (Edge edge : graph.getEdges()) {
                GraphOutputDot.writeEdge(out, edge);
            }
            out.println("}");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            IO.close(out);
            IO.close(writer);
            throw throwable;
        }
        IO.close(out);
        IO.close(writer);
    }

    private static void writeEdge(PrintWriter out, Edge edge) {
        out.println();
        out.println("  // Edge");
        out.printf("  \"%s\" -> \"%s\" [%n", GraphOutputDot.toId(edge.getFrom()), GraphOutputDot.toId(edge.getTo()));
        out.println("    arrowtail=none,");
        out.println("    arrowhead=normal");
        out.println("  ];");
    }

    private static void writeNode(PrintWriter out, Node node) {
        out.println();
        out.println("  // Node");
        out.printf("  \"%s\" [%n", GraphOutputDot.toId(node));
        out.printf("    label=\"%s\",%n", node.getName());
        if (node.getName().endsWith("ed")) {
            out.println("    color=\"#ddddff\",");
            out.println("    style=filled,");
        }
        out.println("    shape=box");
        out.println("  ];");
    }

    private static CharSequence toId(Node node) {
        StringBuilder buf = new StringBuilder();
        for (char c : node.getName().toCharArray()) {
            if (Character.isLetter(c)) {
                buf.append(c);
                continue;
            }
            if (Character.isDigit(c)) {
                buf.append(c);
                continue;
            }
            if (c != ' ' && c != '-' && c != '_') continue;
            buf.append(c);
        }
        return buf;
    }

    private static void writeEdgeDefaults(PrintWriter out) {
        out.println();
        out.println("  // Edge Defaults ");
        out.println("  edge [");
        out.println("    arrowsize=\"0.8\",");
        out.println("    fontsize=\"11\"");
        out.println("  ];");
    }

    private static void writeGraphDefaults(PrintWriter out) {
        out.println();
        out.println("  // Graph Defaults ");
        out.println("  graph [");
        out.println("    bgcolor=\"#ffffff\",");
        out.println("    fontname=\"Helvetica\",");
        out.println("    fontsize=\"11\",");
        out.println("    label=\"Graph\",");
        out.println("    labeljust=\"l\",");
        out.println("    rankdir=\"TD\"");
        out.println("  ];");
    }

    private static void writeNodeDefaults(PrintWriter out) {
        out.println();
        out.println("  // Node Defaults ");
        out.println("  node [");
        out.println("    fontname=\"Helvetica\",");
        out.println("    fontsize=\"11\",");
        out.println("    shap=\"box\"");
        out.println("  ];");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopNodeSort
    implements Comparator<Node> {
        private Collator collator = Collator.getInstance();

        private TopNodeSort() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getName().equals(GraphOutputDot.TOPNODE)) {
                return -1;
            }
            if (o2.getName().equals(GraphOutputDot.TOPNODE)) {
                return 1;
            }
            CollationKey key1 = this.toKey(o1);
            CollationKey key2 = this.toKey(o2);
            return key1.compareTo(key2);
        }

        private CollationKey toKey(Node node) {
            return this.collator.getCollationKey(node.getName());
        }
    }
}

