/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements AsyncEndPoint,
ConnectedEndPoint {
    public static final Logger LOG = Log.getLogger("org.eclipse.jetty.io.nio");
    private final boolean WORK_AROUND_JVM_BUG_6346658 = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    private final SelectorManager.SelectSet _selectSet;
    private final SelectorManager _manager;
    private SelectionKey _key;
    private final Runnable _handler = new Runnable(){

        public void run() {
            SelectChannelEndPoint.this.handle();
        }
    };
    private int _interestOps;
    private volatile AsyncConnection _connection;
    private static final int STATE_NEEDS_DISPATCH = -1;
    private static final int STATE_UNDISPATCHED = 0;
    private static final int STATE_DISPATCHED = 1;
    private static final int STATE_ASYNC = 2;
    private int _state;
    private boolean _onIdle;
    private volatile boolean _writable = true;
    private boolean _readBlocked;
    private boolean _writeBlocked;
    private boolean _open;
    private volatile long _idleTimestamp;
    private volatile boolean _checkIdle;
    private boolean _ishut;

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, int maxIdleTime) throws IOException {
        super(channel, maxIdleTime);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._state = 0;
        this._onIdle = false;
        this._open = true;
        this._key = key;
        this.setCheckForIdle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey getSelectionKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return this._key;
        }
    }

    public SelectorManager getSelectManager() {
        return this._manager;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection connection) {
        AsyncConnection old = this._connection;
        this._connection = (AsyncConnection)connection;
        if (old != null && old != this._connection) {
            this._manager.endPointUpgraded(this, old);
        }
    }

    public long getIdleTimestamp() {
        return this._idleTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null || !this._key.isValid()) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                this._key.interestOps(0);
                if (this._state < 1) {
                    this.updateKey();
                }
                return;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
                this._writable = true;
            }
            if (this._state >= 1) {
                this._key.interestOps(0);
            } else {
                this.dispatch();
                if (this._state >= 1 && !this._selectSet.getManager().isDeferringInterestedOps0()) {
                    this._key.interestOps(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            switch (this._state) {
                case -1: 
                case 0: {
                    this.dispatch();
                    break;
                }
                case 1: 
                case 2: {
                    this._state = 2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._state <= 0) {
                if (this._onIdle) {
                    this._state = -1;
                } else {
                    this._state = 1;
                    boolean dispatched = this._manager.dispatch(this._handler);
                    if (!dispatched) {
                        this._state = -1;
                        LOG.warn("Dispatched Failed! " + this + " to " + this._manager, new Object[0]);
                        this.updateKey();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            switch (this._state) {
                case 2: {
                    this._state = 1;
                    return false;
                }
            }
            this._state = 0;
            this.updateKey();
            return true;
        }
    }

    public void cancelTimeout(Timeout.Task task) {
        this.getSelectSet().cancelTimeout(task);
    }

    public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
        this.getSelectSet().scheduleTimeout(task, timeoutMs);
    }

    public void setCheckForIdle(boolean check) {
        if (check) {
            this._idleTimestamp = System.currentTimeMillis();
            this._checkIdle = true;
        } else {
            this._checkIdle = false;
        }
    }

    public boolean isCheckForIdle() {
        return this._checkIdle;
    }

    protected void notIdle() {
        this._idleTimestamp = System.currentTimeMillis();
    }

    public void checkIdleTimestamp(long now) {
        long idleForMs;
        if (this.isCheckForIdle() && this._maxIdleTime > 0 && (idleForMs = now - this._idleTimestamp) > (long)this._maxIdleTime) {
            this.setCheckForIdle(false);
            this._manager.dispatch(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SelectChannelEndPoint.this.onIdleExpired(idleForMs);
                        Object var2_1 = null;
                        SelectChannelEndPoint.this.setCheckForIdle(true);
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        SelectChannelEndPoint.this.setCheckForIdle(true);
                        throw throwable;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIdleExpired(long idleForMs) {
        SelectChannelEndPoint selectChannelEndPoint;
        try {
            SelectChannelEndPoint selectChannelEndPoint2 = this;
            synchronized (selectChannelEndPoint2) {
                this._onIdle = true;
            }
            if (this._maxIdleTime > 0 && System.currentTimeMillis() - this._idleTimestamp > (long)this._maxIdleTime) {
                this._connection.onIdleExpired(idleForMs);
            }
            Object var6_4 = null;
            selectChannelEndPoint = this;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SelectChannelEndPoint selectChannelEndPoint3 = this;
            synchronized (selectChannelEndPoint3) {
                this._onIdle = false;
                if (this._state == -1) {
                    this.dispatch();
                }
            }
            throw throwable;
        }
        synchronized (selectChannelEndPoint) {
            this._onIdle = false;
            if (this._state == -1) {
                this.dispatch();
            }
        }
    }

    public int fill(Buffer buffer) throws IOException {
        int fill = super.fill(buffer);
        if (fill > 0) {
            this.notIdle();
        }
        return fill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        if (l == 0 && (header != null && header.hasContent() || buffer != null && buffer.hasContent() || trailer != null && trailer.hasContent())) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                this._writable = false;
                if (this._state < 1) {
                    this.updateKey();
                }
            }
        } else if (l > 0) {
            this._writable = true;
            this.notIdle();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        if (l == 0 && buffer != null && buffer.hasContent()) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                this._writable = false;
                if (this._state < 1) {
                    this.updateKey();
                }
            }
        } else if (l > 0) {
            this._writable = true;
            this.notIdle();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockReadable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.isInputShutdown()) {
                throw new EofException();
            }
            long now = this._selectSet.getNow();
            long end = now + timeoutMs;
            boolean check = this.isCheckForIdle();
            this.setCheckForIdle(true);
            try {
                this._readBlocked = true;
                while (!this.isInputShutdown() && this._readBlocked) {
                    block10: {
                        Object var11_8;
                        try {
                            try {
                                this.updateKey();
                                this.wait(timeoutMs > 0L ? end - now : 10000L);
                            }
                            catch (InterruptedException e) {
                                LOG.warn(e);
                                var11_8 = null;
                                now = this._selectSet.getNow();
                                break block10;
                            }
                            var11_8 = null;
                            now = this._selectSet.getNow();
                        }
                        catch (Throwable throwable) {
                            var11_8 = null;
                            now = this._selectSet.getNow();
                            throw throwable;
                        }
                    }
                    if (!this._readBlocked || timeoutMs <= 0L || now < end) continue;
                    boolean bl = false;
                    Object var13_10 = null;
                    this._readBlocked = false;
                    this.setCheckForIdle(check);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                this._readBlocked = false;
                this.setCheckForIdle(check);
                throw throwable;
            }
            Object var13_11 = null;
            this._readBlocked = false;
            this.setCheckForIdle(check);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockWritable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.isOutputShutdown()) {
                throw new EofException();
            }
            long now = this._selectSet.getNow();
            long end = now + timeoutMs;
            boolean check = this.isCheckForIdle();
            this.setCheckForIdle(true);
            try {
                this._writeBlocked = true;
                while (this._writeBlocked && !this.isOutputShutdown()) {
                    block10: {
                        Object var11_8;
                        try {
                            try {
                                this.updateKey();
                                this.wait(timeoutMs > 0L ? end - now : 10000L);
                            }
                            catch (InterruptedException e) {
                                LOG.warn(e);
                                var11_8 = null;
                                now = this._selectSet.getNow();
                                break block10;
                            }
                            var11_8 = null;
                            now = this._selectSet.getNow();
                        }
                        catch (Throwable throwable) {
                            var11_8 = null;
                            now = this._selectSet.getNow();
                            throw throwable;
                        }
                    }
                    if (!this._writeBlocked || timeoutMs <= 0L || now < end) continue;
                    boolean bl = false;
                    Object var13_10 = null;
                    this._writeBlocked = false;
                    this.setCheckForIdle(check);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                this._writeBlocked = false;
                this.setCheckForIdle(check);
                throw throwable;
            }
            Object var13_11 = null;
            this._writeBlocked = false;
            this.setCheckForIdle(check);
            return true;
        }
    }

    public void scheduleWrite() {
        if (this._writable) {
            LOG.debug("Required scheduleWrite {}", this);
        }
        this._writable = false;
        this.updateKey();
    }

    public boolean isWritable() {
        return this._writable;
    }

    public boolean hasProgressed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        boolean changed;
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int current_ops = -1;
            if (this.getChannel().isOpen()) {
                boolean read_interest = this._readBlocked || this._state < 1 && !this._connection.isSuspended();
                boolean write_interest = this._writeBlocked || this._state < 1 && !this._writable;
                this._interestOps = (!this._socket.isInputShutdown() && read_interest ? 1 : 0) | (!this._socket.isOutputShutdown() && write_interest ? 4 : 0);
                try {
                    current_ops = this._key != null && this._key.isValid() ? this._key.interestOps() : -1;
                }
                catch (Exception e) {
                    this._key = null;
                    LOG.ignore(e);
                }
            }
            changed = this._interestOps != current_ops;
        }
        if (changed) {
            this._selectSet.addChange(this);
            this._selectSet.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.getChannel().isOpen()) {
                if (this._interestOps > 0) {
                    if (this._key == null || !this._key.isValid()) {
                        SelectableChannel sc = (SelectableChannel)((Object)this.getChannel());
                        if (sc.isRegistered()) {
                            this.updateKey();
                        } else {
                            try {
                                this._key = ((SelectableChannel)((Object)this.getChannel())).register(this._selectSet.getSelector(), this._interestOps, this);
                            }
                            catch (Exception e) {
                                LOG.ignore(e);
                                if (this._key != null && this._key.isValid()) {
                                    this._key.cancel();
                                }
                                if (this._open) {
                                    this._selectSet.destroyEndPoint(this);
                                }
                                this._open = false;
                                this._key = null;
                            }
                        }
                    } else {
                        this._key.interestOps(this._interestOps);
                    }
                } else if (this._key != null && this._key.isValid()) {
                    this._key.interestOps(0);
                } else {
                    this._key = null;
                }
            } else {
                if (this._key != null && this._key.isValid()) {
                    this._key.cancel();
                }
                if (this._open) {
                    this._open = false;
                    this._selectSet.destroyEndPoint(this);
                }
                this._key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void handle() {
        dispatched = true;
        try {
            while (dispatched) {
                try {
                    block41: {
                        try {
                            while ((next = (AsyncConnection)this._connection.handle()) != this._connection) {
                                SelectChannelEndPoint.LOG.debug("{} replaced {}", new Object[]{next, this._connection});
                                old = this._connection;
                                this._connection = next;
                                this._manager.endPointUpgraded(this, old);
                            }
                            var5_11 = null;
                        }
                        catch (ClosedChannelException e) {
                            block43: {
                                SelectChannelEndPoint.LOG.ignore(e);
                                var5_11 = null;
                                if (this._ishut || !this.isInputShutdown() || !this.isOpen()) break block43;
                                this._ishut = true;
                                try {}
                                catch (Throwable var8_16) {
                                    var9_14 = null;
                                    this.updateKey();
                                    throw var8_16;
                                }
                                try {}
                                catch (Throwable x) {
                                    block48: {
                                        SelectChannelEndPoint.LOG.warn("onInputShutdown failed", x);
                                        ** try [egrp 8[TRYBLOCK] [14 : 271->278)] { 
lbl58:
                                        // 1 sources

                                        this.close();
                                        break block48;
lbl60:
                                        // 1 sources

                                        catch (IOException e2) {
                                            SelectChannelEndPoint.LOG.ignore(e2);
                                        }
                                    }
                                    var9_14 = null;
                                    this.updateKey();
                                    break block43;
                                }
                                this._connection.onInputShutdown();
                                var9_14 = null;
                                this.updateKey();
                            }
                            dispatched = this.undispatch() == false;
                            continue;
                        }
                        catch (EofException e) {
                            block44: {
                                SelectChannelEndPoint.LOG.debug("EOF", e);
                                try {
                                    this.close();
                                }
                                catch (IOException e2) {
                                    SelectChannelEndPoint.LOG.ignore(e2);
                                }
                                var5_11 = null;
                                if (this._ishut || !this.isInputShutdown() || !this.isOpen()) break block44;
                                this._ishut = true;
                                try {}
                                catch (Throwable var8_17) {
                                    var9_14 = null;
                                    this.updateKey();
                                    throw var8_17;
                                }
                                try {}
                                catch (Throwable x) {
                                    block49: {
                                        SelectChannelEndPoint.LOG.warn("onInputShutdown failed", x);
                                        ** try [egrp 8[TRYBLOCK] [14 : 271->278)] { 
lbl96:
                                        // 1 sources

                                        this.close();
                                        break block49;
lbl98:
                                        // 1 sources

                                        catch (IOException e2) {
                                            SelectChannelEndPoint.LOG.ignore(e2);
                                        }
                                    }
                                    var9_14 = null;
                                    this.updateKey();
                                    break block44;
                                }
                                this._connection.onInputShutdown();
                                var9_14 = null;
                                this.updateKey();
                            }
                            dispatched = this.undispatch() == false;
                            continue;
                        }
                        catch (IOException e) {
                            block45: {
                                SelectChannelEndPoint.LOG.warn(e.toString(), new Object[0]);
                                try {
                                    this.close();
                                }
                                catch (IOException e2) {
                                    SelectChannelEndPoint.LOG.ignore(e2);
                                }
                                var5_11 = null;
                                if (this._ishut || !this.isInputShutdown() || !this.isOpen()) break block45;
                                this._ishut = true;
                                try {}
                                catch (Throwable var8_18) {
                                    var9_14 = null;
                                    this.updateKey();
                                    throw var8_18;
                                }
                                try {}
                                catch (Throwable x) {
                                    block50: {
                                        SelectChannelEndPoint.LOG.warn("onInputShutdown failed", x);
                                        ** try [egrp 8[TRYBLOCK] [14 : 271->278)] { 
lbl134:
                                        // 1 sources

                                        this.close();
                                        break block50;
lbl136:
                                        // 1 sources

                                        catch (IOException e2) {
                                            SelectChannelEndPoint.LOG.ignore(e2);
                                        }
                                    }
                                    var9_14 = null;
                                    this.updateKey();
                                    break block45;
                                }
                                this._connection.onInputShutdown();
                                var9_14 = null;
                                this.updateKey();
                            }
                            dispatched = this.undispatch() == false;
                            continue;
                        }
                        catch (Throwable e) {
                            block46: {
                                SelectChannelEndPoint.LOG.warn("handle failed", e);
                                try {
                                    this.close();
                                }
                                catch (IOException e2) {
                                    SelectChannelEndPoint.LOG.ignore(e2);
                                }
                                var5_11 = null;
                                if (this._ishut || !this.isInputShutdown() || !this.isOpen()) break block46;
                                this._ishut = true;
                                try {}
                                catch (Throwable var8_19) {
                                    var9_14 = null;
                                    this.updateKey();
                                    throw var8_19;
                                }
                                try {}
                                catch (Throwable x) {
                                    block51: {
                                        SelectChannelEndPoint.LOG.warn("onInputShutdown failed", x);
                                        ** try [egrp 8[TRYBLOCK] [14 : 271->278)] { 
lbl172:
                                        // 1 sources

                                        this.close();
                                        break block51;
lbl174:
                                        // 1 sources

                                        catch (IOException e2) {
                                            SelectChannelEndPoint.LOG.ignore(e2);
                                        }
                                    }
                                    var9_14 = null;
                                    this.updateKey();
                                    break block46;
                                }
                                this._connection.onInputShutdown();
                                var9_14 = null;
                                this.updateKey();
                            }
                            dispatched = this.undispatch() == false;
                            continue;
                        }
                        if (!this._ishut && this.isInputShutdown() && this.isOpen()) {
                            this._ishut = true;
                            try {
                                try {
                                    this._connection.onInputShutdown();
                                }
                                catch (Throwable x) {
                                    SelectChannelEndPoint.LOG.warn("onInputShutdown failed", x);
                                    try {
                                        this.close();
                                    }
                                    catch (IOException e2) {
                                        SelectChannelEndPoint.LOG.ignore(e2);
                                    }
                                    var9_14 = null;
                                    this.updateKey();
                                    break block41;
                                }
                                var9_14 = null;
                                this.updateKey();
                            }
                            catch (Throwable var8_15) {
                                var9_14 = null;
                                this.updateKey();
                                throw var8_15;
                            }
                        }
                    }
                    dispatched = this.undispatch() == false;
                }
                catch (Throwable var4_21) {
                    block47: {
                        var5_11 = null;
                        if (this._ishut || !this.isInputShutdown() || !this.isOpen()) break block47;
                        this._ishut = true;
                        try {}
                        catch (Throwable var8_20) {
                            var9_14 = null;
                            this.updateKey();
                            throw var8_20;
                        }
                        try {}
                        catch (Throwable x) {
                            block52: {
                                SelectChannelEndPoint.LOG.warn("onInputShutdown failed", x);
                                ** try [egrp 8[TRYBLOCK] [14 : 271->278)] { 
lbl204:
                                // 1 sources

                                this.close();
                                break block52;
lbl206:
                                // 1 sources

                                catch (IOException e2) {
                                    SelectChannelEndPoint.LOG.ignore(e2);
                                }
                            }
                            var9_14 = null;
                            this.updateKey();
                            break block47;
                        }
                        this._connection.onInputShutdown();
                        var9_14 = null;
                        this.updateKey();
                    }
                    dispatched = this.undispatch() == false;
                    throw var4_21;
                }
            }
            var11_22 = null;
            if (dispatched == false) return;
            dispatched = this.undispatch() == false;
        }
        catch (Throwable var10_24) {
            block53: {
                break block53;
lbl227:
                // 2 sources

                while (dispatched != false) {
                    SelectChannelEndPoint.LOG.warn("SCEP.run() finally DISPATCHED", new Object[0]);
                    dispatched = this.undispatch() == false;
                }
                return;
            }
            var11_23 = null;
            if (dispatched == false) throw var10_24;
            dispatched = this.undispatch() == false;
            while (dispatched != false) {
                SelectChannelEndPoint.LOG.warn("SCEP.run() finally DISPATCHED", new Object[0]);
                dispatched = this.undispatch() == false;
            }
            throw var10_24;
        }
        ** GOTO lbl227
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.WORK_AROUND_JVM_BUG_6346658) {
            try {
                SelectionKey key = this._key;
                if (key != null) {
                    key.cancel();
                }
            }
            catch (Throwable e) {
                LOG.ignore(e);
            }
        }
        try {
            try {
                super.close();
            }
            catch (IOException e) {
                LOG.ignore(e);
                Object var3_5 = null;
                this.updateKey();
            }
            Object var3_4 = null;
            this.updateKey();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.updateKey();
            throw throwable;
        }
    }

    public String toString() {
        SelectionKey key = this._key;
        String keyString = "";
        if (key != null) {
            if (key.isValid()) {
                if (key.isReadable()) {
                    keyString = keyString + "r";
                }
                if (key.isWritable()) {
                    keyString = keyString + "w";
                }
            } else {
                keyString = keyString + "!";
            }
        } else {
            keyString = keyString + "-";
        }
        return String.format("SCEP@%x{l(%s)<->r(%s),s=%d,open=%b,ishut=%b,oshut=%b,rb=%b,wb=%b,w=%b,i=%d%s}-{%s}", this.hashCode(), this._socket.getRemoteSocketAddress(), this._socket.getLocalSocketAddress(), this._state, this.isOpen(), this.isInputShutdown(), this.isOutputShutdown(), this._readBlocked, this._writeBlocked, this._writable, this._interestOps, keyString, this._connection);
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    public void setMaxIdleTime(int timeMs) throws IOException {
        this._maxIdleTime = timeMs;
    }
}

