/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.triggers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.jetty.monitor.JMXMonitor;
import org.eclipse.jetty.monitor.jmx.EventState;
import org.eclipse.jetty.monitor.jmx.EventTrigger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrEventTrigger<TYPE extends Comparable<TYPE>>
extends EventTrigger {
    private static final Logger LOG = Log.getLogger(AttrEventTrigger.class);
    private final ObjectName _nameObject;
    protected final String _objectName;
    protected final String _attributeName;
    protected Map<Long, EventState<TYPE>> _states;

    public AttrEventTrigger(String objectName, String attributeName) throws MalformedObjectNameException, IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("Object name cannot be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        this._states = new ConcurrentHashMap<Long, EventState<TYPE>>();
        this._objectName = objectName;
        this._attributeName = attributeName;
        this._nameObject = new ObjectName(this._objectName);
    }

    public AttrEventTrigger(ObjectName nameObject, String attributeName) throws IllegalArgumentException {
        if (nameObject == null) {
            throw new IllegalArgumentException("Object name cannot be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        this._states = new ConcurrentHashMap<Long, EventState<TYPE>>();
        this._objectName = nameObject.toString();
        this._attributeName = attributeName;
        this._nameObject = nameObject;
    }

    @Override
    public final boolean match(long timestamp) throws Exception {
        MBeanServerConnection serverConnection = JMXMonitor.getServiceConnection();
        Comparable<Object> value = null;
        try {
            int pos = this._attributeName.indexOf(46);
            value = pos < 0 ? (Comparable)serverConnection.getAttribute(this._nameObject, this._attributeName) : this.getValue((CompositeData)serverConnection.getAttribute(this._nameObject, this._attributeName.substring(0, pos)), this._attributeName.substring(pos + 1));
        }
        catch (Exception ex) {
            LOG.debug(ex);
        }
        boolean result = false;
        if (value != null && ((result = this.match(value)) || this.getSaveAll())) {
            this._states.put(timestamp, new EventState<Comparable>(this.getID(), this.getNameString(), value));
        }
        return result;
    }

    public boolean match(Comparable<TYPE> value) {
        return true;
    }

    public final EventState<TYPE> getState(long timestamp) {
        return this._states.get(timestamp);
    }

    public String toString() {
        return this.getNameString();
    }

    protected String getNameString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        result.append(this._objectName);
        result.append(":");
        result.append(this._attributeName);
        result.append("]");
        return result.toString();
    }

    protected boolean getSaveAll() {
        return true;
    }

    protected TYPE getValue(CompositeData compValue, String fieldName) {
        int pos = fieldName.indexOf(46);
        if (pos < 0) {
            return (TYPE)((Comparable)compValue.get(fieldName));
        }
        return this.getValue((CompositeData)compValue.get(fieldName.substring(0, pos)), fieldName.substring(pos + 1));
    }
}

