/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.overlays;

import java.io.IOException;
import java.security.PermissionCollection;
import java.util.Map;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.ClasspathPattern;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateContext
extends AggregateLifeCycle
implements WebAppClassLoader.Context,
Destroyable {
    private final ClassLoader _libLoader;
    private final Resource _baseResource;
    private final ResourceCache _resourceCache;
    private final Server _server;
    private final MimeTypes _mimeTypes;
    private final WebAppClassLoader _webappLoader;
    private ClasspathPattern _systemClasses;
    private ClasspathPattern _serverClasses;
    private PermissionCollection _permissions;
    private boolean _parentLoaderPriority;
    private String _extraClasspath;
    private Map<String, Object> _idMap;

    public ClassLoader getLibLoader() {
        return this._libLoader;
    }

    public TemplateContext() {
        this._server = null;
        this._baseResource = null;
        this._mimeTypes = new MimeTypes();
        this._resourceCache = null;
        this._webappLoader = null;
        this._libLoader = null;
    }

    public TemplateContext(String key, Server server, Resource baseResource, ClassLoader libLoader) throws IOException {
        this._server = server;
        this._baseResource = baseResource;
        this._mimeTypes = new MimeTypes();
        this._resourceCache = new ResourceCache(null, baseResource, this._mimeTypes, false, false);
        String[] patterns = (String[])this._server.getAttribute("org.eclipse.jetty.webapp.serverClasses");
        this._serverClasses = new ClasspathPattern(patterns == null ? WebAppContext.__dftServerClasses : patterns);
        patterns = (String[])this._server.getAttribute("org.eclipse.jetty.webapp.systemClasses");
        this._systemClasses = new ClasspathPattern(patterns == null ? WebAppContext.__dftSystemClasses : patterns);
        this._libLoader = libLoader;
        Resource classes = this.getBaseResource().addPath("WEB-INF/classes/");
        Resource lib = this.getBaseResource().addPath("WEB-INF/lib/");
        if (classes.exists() && classes.isDirectory() || lib.exists() && lib.isDirectory()) {
            this._webappLoader = new WebAppClassLoader(this._libLoader, this);
            this._webappLoader.setName(key);
            if (classes.exists()) {
                this._webappLoader.addClassPath(classes);
            }
            if (lib.exists()) {
                this._webappLoader.addJars(lib);
            }
        } else {
            this._webappLoader = null;
        }
    }

    public Resource getBaseResource() {
        return this._baseResource;
    }

    @Override
    public String getExtraClasspath() {
        return this._extraClasspath;
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    @Override
    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public ResourceCache getResourceCache() {
        return this._resourceCache;
    }

    public Server getServer() {
        return this._server;
    }

    WebAppClassLoader getWebappLoader() {
        return this._webappLoader;
    }

    @Override
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    @Override
    public boolean isServerClass(String clazz) {
        return this._serverClasses.match(clazz);
    }

    @Override
    public boolean isSystemClass(String clazz) {
        return this._systemClasses.match(clazz);
    }

    @Override
    public Resource newResource(String urlOrPath) throws IOException {
        return Resource.newResource(urlOrPath);
    }

    public void setExtraClasspath(String extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = new ClasspathPattern(serverClasses);
    }

    public void setSystemClasses(String[] systemClasses) {
        this._systemClasses = new ClasspathPattern(systemClasses);
    }

    public void addSystemClass(String classname) {
        this._systemClasses.addPattern(classname);
    }

    public void addServerClass(String classname) {
        this._serverClasses.addPattern(classname);
    }

    @Override
    public void destroy() {
        if (this._baseResource != null) {
            this._baseResource.release();
        }
        if (this._resourceCache != null) {
            this._resourceCache.flushCache();
        }
        if (this._idMap != null) {
            this._idMap.clear();
        }
    }

    public void setIdMap(Map<String, Object> idMap) {
        this._idMap = idMap;
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }
}

