/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.policy.JettyPolicy;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.loader.DefaultPolicyLoader;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public abstract class PolicyMonitor
extends AbstractLifeCycle {
    private String _policyDirectory;
    private Scanner _scanner;
    private boolean _reload = true;
    private int _scanInterval = 1;
    private LatchScannerListener _scanningListener;
    private boolean _initialized = false;
    private AtomicInteger _scanCount = new AtomicInteger(0);

    public PolicyMonitor() {
    }

    public PolicyMonitor(String directory) {
        this();
        this._policyDirectory = directory;
    }

    public void setPolicyDirectory(String directory) {
        if (this.isRunning()) {
            throw new PolicyException("policy monitor is running, unable to set policy directory");
        }
        this._policyDirectory = directory;
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        if (this.isRunning()) {
            throw new PolicyException("policy monitor is running, unable to set scan interval");
        }
        this._scanInterval = scanInterval;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public int getScanCount() {
        return this._scanCount.get();
    }

    public synchronized void waitForScan() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this._scanningListener.setScanningLatch(latch);
        this._scanner.scan();
        latch.await();
    }

    public boolean isReloadEnabled() {
        return this._reload;
    }

    public void setReload(boolean reload) {
        if (this.isRunning()) {
            throw new PolicyException("policy monitor is running, unable to set reload at this time");
        }
        this._reload = reload;
    }

    private void processPolicyFile(String filename) {
        try {
            File policyFile = new File(filename);
            Set<PolicyBlock> policyBlocks = DefaultPolicyLoader.load(new FileInputStream(policyFile), JettyPolicy.getContext());
            for (PolicyBlock policy : policyBlocks) {
                this.onPolicyChange(policy);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._scanner = new Scanner();
        ArrayList<File> scanDirs = new ArrayList<File>();
        scanDirs.add(new File(this._policyDirectory));
        this._scanner.addListener(new Scanner.DiscreteListener(){

            public void fileRemoved(String filename) throws Exception {
            }

            public void fileChanged(String filename) throws Exception {
                if (PolicyMonitor.this._reload && filename.endsWith("policy")) {
                    PolicyMonitor.this.processPolicyFile(filename);
                }
            }

            public void fileAdded(String filename) throws Exception {
                if (filename.endsWith("policy")) {
                    PolicyMonitor.this.processPolicyFile(filename);
                }
            }
        });
        this._scanningListener = new LatchScannerListener();
        this._scanner.addListener(this._scanningListener);
        this._scanner.setScanDirs(scanDirs);
        this._scanner.setReportExistingFilesOnStartup(true);
        this._scanner.start();
        this._scanner.setScanInterval(this._scanInterval);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._scanner.stop();
    }

    public abstract void onPolicyChange(PolicyBlock var1);

    private class LatchScannerListener
    implements Scanner.ScanCycleListener {
        CountDownLatch _latch;

        private LatchScannerListener() {
        }

        public void scanStarted(int cycle) throws Exception {
        }

        public void scanEnded(int cycle) throws Exception {
            PolicyMonitor.this._initialized = true;
            PolicyMonitor.this._scanCount.incrementAndGet();
            if (this._latch != null) {
                this._latch.countDown();
            }
        }

        public void setScanningLatch(CountDownLatch latch) {
            this._latch = latch;
        }
    }
}

