/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityHandler
extends HandlerWrapper
implements Authenticator.AuthConfiguration {
    private static final Logger LOG = Log.getLogger(SecurityHandler.class);
    private boolean _checkWelcomeFiles = false;
    private Authenticator _authenticator;
    private Authenticator.Factory _authenticatorFactory = new DefaultAuthenticatorFactory();
    private String _realmName;
    private String _authMethod;
    private final Map<String, String> _initParameters = new HashMap<String, String>();
    private LoginService _loginService;
    private boolean _loginServiceShared;
    private IdentityService _identityService;
    private boolean _renewSession = true;
    public static Principal __NO_USER = new Principal(){

        public String getName() {
            return null;
        }

        public String toString() {
            return "No User";
        }
    };
    public static Principal __NOBODY = new Principal(){

        public String getName() {
            return "Nobody";
        }

        public String toString() {
            return this.getName();
        }
    };

    protected SecurityHandler() {
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._identityService = identityService;
    }

    @Override
    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._loginService = loginService;
        this._loginServiceShared = false;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._authenticator = authenticator;
    }

    public Authenticator.Factory getAuthenticatorFactory() {
        return this._authenticatorFactory;
    }

    public void setAuthenticatorFactory(Authenticator.Factory authenticatorFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authenticatorFactory = authenticatorFactory;
    }

    @Override
    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._realmName = realmName;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String authMethod) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authMethod = authMethod;
    }

    public boolean isCheckWelcomeFiles() {
        return this._checkWelcomeFiles;
    }

    public void setCheckWelcomeFiles(boolean authenticateWelcomeFiles) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._checkWelcomeFiles = authenticateWelcomeFiles;
    }

    @Override
    public String getInitParameter(String key) {
        return this._initParameters.get(key);
    }

    @Override
    public Set<String> getInitParameterNames() {
        return this._initParameters.keySet();
    }

    public String setInitParameter(String key, String value) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        return this._initParameters.put(key, value);
    }

    protected LoginService findLoginService() {
        List<LoginService> list = this.getServer().getBeans(LoginService.class);
        String realm = this.getRealmName();
        if (realm != null) {
            for (LoginService service : list) {
                if (service.getName() == null || !service.getName().equals(realm)) continue;
                return service;
            }
        } else if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    protected IdentityService findIdentityService() {
        return this.getServer().getBean(IdentityService.class);
    }

    @Override
    protected void doStart() throws Exception {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null) {
            Enumeration names = context.getInitParameterNames();
            while (names != null && names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("org.eclipse.jetty.security.") || this.getInitParameter(name) != null) continue;
                this.setInitParameter(name, context.getInitParameter(name));
            }
            context.getContextHandler().addEventListener(new HttpSessionListener(){

                public void sessionDestroyed(HttpSessionEvent se) {
                }

                public void sessionCreated(HttpSessionEvent se) {
                    AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
                    if (connection == null) {
                        return;
                    }
                    Request request = connection.getRequest();
                    if (request == null) {
                        return;
                    }
                    if (request.isSecure()) {
                        se.getSession().setAttribute("org.eclipse.jetty.security.sessionKnownOnlytoAuthenticated", Boolean.TRUE);
                    }
                }
            });
        }
        if (this._loginService == null) {
            this._loginService = this.findLoginService();
            if (this._loginService != null) {
                this._loginServiceShared = true;
            }
        }
        if (this._identityService == null) {
            if (this._loginService != null) {
                this._identityService = this._loginService.getIdentityService();
            }
            if (this._identityService == null) {
                this._identityService = this.findIdentityService();
            }
            if (this._identityService == null && this._realmName != null) {
                this._identityService = new DefaultIdentityService();
            }
        }
        if (this._loginService != null) {
            if (this._loginService.getIdentityService() == null) {
                this._loginService.setIdentityService(this._identityService);
            } else if (this._loginService.getIdentityService() != this._identityService) {
                throw new IllegalStateException("LoginService has different IdentityService to " + this);
            }
        }
        if (!this._loginServiceShared && this._loginService instanceof LifeCycle) {
            ((LifeCycle)((Object)this._loginService)).start();
        }
        if (this._authenticator == null && this._authenticatorFactory != null && this._identityService != null) {
            this._authenticator = this._authenticatorFactory.getAuthenticator(this.getServer(), ContextHandler.getCurrentContext(), this, this._identityService, this._loginService);
            if (this._authenticator != null) {
                this._authMethod = this._authenticator.getAuthMethod();
            }
        }
        if (this._authenticator == null) {
            if (this._realmName != null) {
                LOG.warn("No ServerAuthentication for " + this, new Object[0]);
                throw new IllegalStateException("No ServerAuthentication");
            }
        } else {
            this._authenticator.setConfiguration(this);
            if (this._authenticator instanceof LifeCycle) {
                ((LifeCycle)((Object)this._authenticator)).start();
            }
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (!this._loginServiceShared && this._loginService instanceof LifeCycle) {
            ((LifeCycle)((Object)this._loginService)).stop();
        }
    }

    protected boolean checkSecurity(Request request) {
        switch (request.getDispatcherType()) {
            case REQUEST: 
            case ASYNC: {
                return true;
            }
            case FORWARD: {
                if (this._checkWelcomeFiles && request.getAttribute("org.eclipse.jetty.server.welcome") != null) {
                    request.removeAttribute("org.eclipse.jetty.server.welcome");
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isSessionRenewedOnAuthentication() {
        return this._renewSession;
    }

    public void setSessionRenewedOnAuthentication(boolean renew) {
        this._renewSession = renew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object previousIdentity;
        block23: {
            Response base_response = baseRequest.getResponse();
            Handler handler = this.getHandler();
            if (handler == null) {
                return;
            }
            Authenticator authenticator = this._authenticator;
            if (!this.checkSecurity(baseRequest)) {
                handler.handle(pathInContext, baseRequest, request, response);
                return;
            }
            Object constraintInfo = this.prepareConstraintInfo(pathInContext, baseRequest);
            if (!this.checkUserDataPermissions(pathInContext, baseRequest, base_response, constraintInfo)) {
                if (baseRequest.isHandled()) return;
                response.sendError(403);
                baseRequest.setHandled(true);
                return;
            }
            boolean isAuthMandatory = this.isAuthMandatory(baseRequest, base_response, constraintInfo);
            if (isAuthMandatory && authenticator == null) {
                LOG.warn("No authenticator for: " + constraintInfo, new Object[0]);
                if (baseRequest.isHandled()) return;
                response.sendError(403);
                baseRequest.setHandled(true);
                return;
            }
            previousIdentity = null;
            try {
                try {
                    Authentication authentication = baseRequest.getAuthentication();
                    if (authentication == null || authentication == Authentication.NOT_CHECKED) {
                        Authentication authentication2 = authentication = authenticator == null ? Authentication.UNAUTHENTICATED : authenticator.validateRequest(request, response, isAuthMandatory);
                    }
                    if (authentication instanceof Authentication.Wrapped) {
                        request = ((Authentication.Wrapped)authentication).getHttpServletRequest();
                        response = ((Authentication.Wrapped)authentication).getHttpServletResponse();
                    }
                    if (authentication instanceof Authentication.ResponseSent) {
                        baseRequest.setHandled(true);
                        break block23;
                    }
                    if (authentication instanceof Authentication.User) {
                        boolean authorized;
                        Authentication.User userAuth = (Authentication.User)authentication;
                        baseRequest.setAuthentication(authentication);
                        if (this._identityService != null) {
                            previousIdentity = this._identityService.associate(userAuth.getUserIdentity());
                        }
                        if (isAuthMandatory && !(authorized = this.checkWebResourcePermissions(pathInContext, baseRequest, base_response, constraintInfo, userAuth.getUserIdentity()))) {
                            response.sendError(403, "!role");
                            baseRequest.setHandled(true);
                            Object var17_17 = null;
                            if (this._identityService == null) return;
                            this._identityService.disassociate(previousIdentity);
                            return;
                        }
                        handler.handle(pathInContext, baseRequest, request, response);
                        if (authenticator != null) {
                            authenticator.secureResponse(request, response, isAuthMandatory, userAuth);
                        }
                        break block23;
                    }
                    if (authentication instanceof Authentication.Deferred) {
                        DeferredAuthentication deferred = (DeferredAuthentication)authentication;
                        baseRequest.setAuthentication(authentication);
                        try {
                            handler.handle(pathInContext, baseRequest, request, response);
                            Object var15_21 = null;
                            previousIdentity = deferred.getPreviousAssociation();
                        }
                        catch (Throwable throwable) {
                            Object var15_22 = null;
                            previousIdentity = deferred.getPreviousAssociation();
                            throw throwable;
                        }
                        if (authenticator == null) break block23;
                        Authentication auth = baseRequest.getAuthentication();
                        if (auth instanceof Authentication.User) {
                            Authentication.User userAuth = (Authentication.User)auth;
                            authenticator.secureResponse(request, response, isAuthMandatory, userAuth);
                            break block23;
                        } else {
                            authenticator.secureResponse(request, response, isAuthMandatory, null);
                        }
                        break block23;
                    }
                    baseRequest.setAuthentication(authentication);
                    if (this._identityService != null) {
                        previousIdentity = this._identityService.associate(null);
                    }
                    handler.handle(pathInContext, baseRequest, request, response);
                    if (authenticator != null) {
                        authenticator.secureResponse(request, response, isAuthMandatory, null);
                    }
                }
                catch (ServerAuthException e) {
                    response.sendError(500, e.getMessage());
                    Object var17_19 = null;
                    if (this._identityService == null) return;
                    this._identityService.disassociate(previousIdentity);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (this._identityService == null) throw throwable;
                this._identityService.disassociate(previousIdentity);
                throw throwable;
            }
        }
        Object var17_18 = null;
        if (this._identityService == null) return;
        this._identityService.disassociate(previousIdentity);
    }

    public static SecurityHandler getCurrentSecurityHandler() {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context == null) {
            return null;
        }
        SecurityHandler security = context.getContextHandler().getChildHandlerByClass(SecurityHandler.class);
        return security;
    }

    public void logout(Authentication.User user) {
        IdentityService identity_service;
        LOG.debug("logout {}", user);
        LoginService login_service = this.getLoginService();
        if (login_service != null) {
            login_service.logout(user.getUserIdentity());
        }
        if ((identity_service = this.getIdentityService()) != null) {
            Object previous = null;
            identity_service.disassociate(previous);
        }
    }

    protected abstract Object prepareConstraintInfo(String var1, Request var2);

    protected abstract boolean checkUserDataPermissions(String var1, Request var2, Response var3, Object var4) throws IOException;

    protected abstract boolean isAuthMandatory(Request var1, Response var2, Object var3);

    protected abstract boolean checkWebResourcePermissions(String var1, Request var2, Response var3, Object var4, UserIdentity var5) throws IOException;

    public class NotChecked
    implements Principal {
        public String getName() {
            return null;
        }

        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

