/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.util.thread.ThreadPool;

public class Server
extends HandlerWrapper
implements Attributes {
    private static final Logger LOG = Log.getLogger(Server.class);
    private static final String __version = Server.class.getPackage() != null && "Eclipse.org - Jetty".equals(Server.class.getPackage().getImplementationVendor()) && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : System.getProperty("jetty.version", "8.y.z-SNAPSHOT");
    private final Container _container = new Container();
    private final AttributesMap _attributes = new AttributesMap();
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private SessionIdManager _sessionIdManager;
    private boolean _sendServerVersion = true;
    private boolean _sendDateHeader = false;
    private int _graceful = 0;
    private boolean _stopAtShutdown;
    private boolean _dumpAfterStart = false;
    private boolean _dumpBeforeStop = false;
    private boolean _uncheckedPrintWriter = false;

    public Server() {
        this.setServer(this);
    }

    public Server(int port) {
        this.setServer(this);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        this.setConnectors(new Connector[]{connector});
    }

    public Server(InetSocketAddress addr) {
        this.setServer(this);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(addr.getHostName());
        connector.setPort(addr.getPort());
        this.setConnectors(new Connector[]{connector});
    }

    public static String getVersion() {
        return __version;
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return this._stopAtShutdown;
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this._stopAtShutdown && this.isStarted()) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this._stopAtShutdown = stop;
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors(LazyList.addToArray(this.getConnectors(), connector, Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors(LazyList.removeFromArray(this.getConnectors(), connector));
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
        this._container.update((Object)this, this._connectors, connectors, "connector");
        this._connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (this._threadPool != null) {
            this.removeBean(this._threadPool);
        }
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool", false);
        this._threadPool = threadPool;
        if (this._threadPool != null) {
            this.addBean(this._threadPool);
        }
    }

    public boolean isDumpAfterStart() {
        return this._dumpAfterStart;
    }

    public void setDumpAfterStart(boolean dumpAfterStart) {
        this._dumpAfterStart = dumpAfterStart;
    }

    public boolean isDumpBeforeStop() {
        return this._dumpBeforeStop;
    }

    public void setDumpBeforeStop(boolean dumpBeforeStop) {
        this._dumpBeforeStop = dumpBeforeStop;
    }

    protected void doStart() throws Exception {
        if (this.getStopAtShutdown()) {
            ShutdownThread.register(this);
        }
        ShutdownMonitor.getInstance().start();
        LOG.info("jetty-" + __version, new Object[0]);
        HttpGenerator.setServerVersion(__version);
        MultiException mex = new MultiException();
        if (this._threadPool == null) {
            this.setThreadPool(new QueuedThreadPool());
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._connectors != null && mex.size() == 0) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        if (this.isDumpAfterStart()) {
            this.dumpStdErr();
        }
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        if (this.isDumpBeforeStop()) {
            this.dumpStdErr();
        }
        MultiException mex = new MultiException();
        if (this._graceful > 0) {
            if (this._connectors != null) {
                int i = this._connectors.length;
                while (i-- > 0) {
                    LOG.info("Graceful shutdown {}", this._connectors[i]);
                    try {
                        this._connectors[i].close();
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                }
            }
            Handler[] contexts = this.getChildHandlersByClass(Graceful.class);
            for (int c = 0; c < contexts.length; ++c) {
                Graceful context = (Graceful)contexts[c];
                LOG.info("Graceful shutdown {}", context);
                context.setShutdown(true);
            }
            Thread.sleep(this._graceful);
        }
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
        if (this.getStopAtShutdown()) {
            ShutdownThread.deregister(this);
        }
    }

    public void handle(AbstractHttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        Request request = connection.getRequest();
        Response response = connection.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("REQUEST " + target + " on " + connection, new Object[0]);
            this.handle(target, request, request, response);
            LOG.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus() + " handled=" + request.isHandled(), new Object[0]);
        } else {
            this.handle(target, request, request, response);
        }
    }

    public void handleAsync(AbstractHttpConnection connection) throws IOException, ServletException {
        AsyncContinuation async = connection.getRequest().getAsyncContinuation();
        AsyncContinuation.AsyncEventState state = async.getAsyncEventState();
        Request baseRequest = connection.getRequest();
        String path = state.getPath();
        if (path != null) {
            String contextPath = state.getServletContext().getContextPath();
            HttpURI uri = new HttpURI(URIUtil.addPaths(contextPath, path));
            baseRequest.setUri(uri);
            baseRequest.setRequestURI(null);
            baseRequest.setPathInfo(baseRequest.getRequestURI());
            if (uri.getQuery() != null) {
                baseRequest.mergeQueryString(uri.getQuery());
            }
        }
        String target = baseRequest.getPathInfo();
        HttpServletRequest request = (HttpServletRequest)async.getRequest();
        HttpServletResponse response = (HttpServletResponse)async.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("REQUEST " + target + " on " + connection, new Object[0]);
            this.handle(target, baseRequest, request, response);
            LOG.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus(), new Object[0]);
        } else {
            this.handle(target, baseRequest, request, response);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        if (this._sessionIdManager != null) {
            this.removeBean(this._sessionIdManager);
        }
        this._container.update((Object)this, this._sessionIdManager, sessionIdManager, "sessionIdManager", false);
        this._sessionIdManager = sessionIdManager;
        if (this._sessionIdManager != null) {
            this.addBean(this._sessionIdManager);
        }
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this._sendDateHeader = sendDateHeader;
    }

    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    @Deprecated
    public int getMaxCookieVersion() {
        return 1;
    }

    @Deprecated
    public void setMaxCookieVersion(int maxCookieVersion) {
    }

    @Deprecated
    public void addLifeCycle(LifeCycle c) {
        this.addBean(c);
    }

    public boolean addBean(Object o) {
        if (super.addBean(o)) {
            this._container.addBean(o);
            return true;
        }
        return false;
    }

    @Deprecated
    public void removeLifeCycle(LifeCycle c) {
        this.removeBean(c);
    }

    public boolean removeBean(Object o) {
        if (super.removeBean(o)) {
            this._container.removeBean(o);
            return true;
        }
        return false;
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public int getGracefulShutdown() {
        return this._graceful;
    }

    public void setGracefulShutdown(int timeoutMS) {
        this._graceful = timeoutMS;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        Server.dump(out, indent, TypeUtil.asList(this.getHandlers()), this.getBeans(), TypeUtil.asList(this._connectors));
    }

    public boolean isUncheckedPrintWriter() {
        return this._uncheckedPrintWriter;
    }

    public void setUncheckedPrintWriter(boolean unchecked) {
        this._uncheckedPrintWriter = unchecked;
    }

    public static void main(String ... args) throws Exception {
        System.err.println(Server.getVersion());
    }

    public static interface Graceful
    extends Handler {
        public void setShutdown(boolean var1);
    }
}

