/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.eclipse.jetty.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        KeyStore keystore = null;
        if (storeStream == null && storePath == null) return keystore;
        InputStream inStream = storeStream;
        try {
            if (inStream == null) {
                inStream = Resource.newResource(storePath).getInputStream();
            }
            keystore = storeProvider != null ? KeyStore.getInstance(storeType, storeProvider) : KeyStore.getInstance(storeType);
            keystore.load(inStream, storePassword == null ? null : storePassword.toCharArray());
            Object var8_7 = null;
            if (inStream == null) return keystore;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inStream == null) throw throwable;
            inStream.close();
            throw throwable;
        }
        inStream.close();
        return keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        Collection<? extends CRL> crlList = null;
        if (crlPath == null) return crlList;
        InputStream in = null;
        try {
            in = Resource.newResource(crlPath).getInputStream();
            crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            Object var4_3 = null;
            if (in == null) return crlList;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
        return crlList;
    }
}

