/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.DeflateFrameExtension;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.FragmentExtension;
import org.eclipse.jetty.websocket.IdentityExtension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketServletConnection;
import org.eclipse.jetty.websocket.WebSocketServletConnectionD00;
import org.eclipse.jetty.websocket.WebSocketServletConnectionD06;
import org.eclipse.jetty.websocket.WebSocketServletConnectionD08;
import org.eclipse.jetty.websocket.WebSocketServletConnectionRFC6455;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketFactory
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(WebSocketFactory.class);
    private final Queue<WebSocketServletConnection> connections = new ConcurrentLinkedQueue<WebSocketServletConnection>();
    private final Map<String, Class<? extends Extension>> _extensionClasses = new HashMap<String, Class<? extends Extension>>();
    private final Acceptor _acceptor;
    private WebSocketBuffers _buffers;
    private int _maxIdleTime;
    private int _maxTextMessageSize;
    private int _maxBinaryMessageSize;
    private int _minVersion;

    public WebSocketFactory(Acceptor acceptor) {
        this(acceptor, 65536, 13);
    }

    public WebSocketFactory(Acceptor acceptor, int bufferSize) {
        this(acceptor, bufferSize, 13);
    }

    public WebSocketFactory(Acceptor acceptor, int bufferSize, int minVersion) {
        this._extensionClasses.put("identity", IdentityExtension.class);
        this._extensionClasses.put("fragment", FragmentExtension.class);
        this._extensionClasses.put("x-deflate-frame", DeflateFrameExtension.class);
        this._maxIdleTime = 300000;
        this._maxTextMessageSize = 16384;
        this._maxBinaryMessageSize = -1;
        this._buffers = new WebSocketBuffers(bufferSize);
        this._acceptor = acceptor;
        this._minVersion = 13;
    }

    public int getMinVersion() {
        return this._minVersion;
    }

    public void setMinVersion(int minVersion) {
        this._minVersion = minVersion;
    }

    public Map<String, Class<? extends Extension>> getExtensionClassesMap() {
        return this._extensionClasses;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getBufferSize() {
        return this._buffers.getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize != this.getBufferSize()) {
            this._buffers = new WebSocketBuffers(bufferSize);
        }
    }

    public int getMaxTextMessageSize() {
        return this._maxTextMessageSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this._maxTextMessageSize = maxTextMessageSize;
    }

    public int getMaxBinaryMessageSize() {
        return this._maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this._maxBinaryMessageSize = maxBinaryMessageSize;
    }

    @Override
    protected void doStop() throws Exception {
        this.closeConnections();
    }

    public void upgrade(HttpServletRequest request, HttpServletResponse response, WebSocket websocket, String protocol) throws IOException {
        AbstractConnection connection;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("!Upgrade:websocket");
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            throw new IllegalStateException("!HTTP/1.1");
        }
        int draft = request.getIntHeader("Sec-WebSocket-Version");
        if (draft < 0) {
            draft = request.getIntHeader("Sec-WebSocket-Draft");
        }
        int requestedVersion = draft;
        AbstractHttpConnection http = AbstractHttpConnection.getCurrentConnection();
        if (http instanceof BlockingHttpConnection) {
            throw new IllegalStateException("Websockets not supported on blocking connectors");
        }
        ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
        ArrayList<String> extensions_requested = new ArrayList<String>();
        Enumeration<String> e = request.getHeaders("Sec-WebSocket-Extensions");
        while (e.hasMoreElements()) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer(e.nextElement(), ",");
            while (tok.hasMoreTokens()) {
                extensions_requested.add(tok.nextToken());
            }
        }
        if (draft < this._minVersion) {
            draft = Integer.MAX_VALUE;
        }
        switch (draft) {
            case -1: 
            case 0: {
                connection = new WebSocketServletConnectionD00(this, websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                connection = new WebSocketServletConnectionD06(this, websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol);
                break;
            }
            case 7: 
            case 8: {
                List<Extension> extensions = this.initExtensions(extensions_requested, 5, 5, 3);
                connection = new WebSocketServletConnectionD08(this, websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, extensions, draft);
                break;
            }
            case 13: {
                List<Extension> extensions = this.initExtensions(extensions_requested, 5, 5, 3);
                connection = new WebSocketServletConnectionRFC6455(this, websocket, endp, this._buffers, http.getTimeStamp(), this._maxIdleTime, protocol, extensions, draft);
                break;
            }
            default: {
                String versions = "13";
                if (this._minVersion <= 8) {
                    versions = versions + ", 8";
                }
                if (this._minVersion <= 6) {
                    versions = versions + ", 6";
                }
                if (this._minVersion <= 0) {
                    versions = versions + ", 0";
                }
                response.setHeader("Sec-WebSocket-Version", versions);
                StringBuilder err = new StringBuilder();
                err.append("Unsupported websocket client version specification ");
                if (requestedVersion >= 0) {
                    err.append("[").append(requestedVersion).append("]");
                } else {
                    err.append("<Unspecified, likely a pre-draft version of websocket>");
                }
                err.append(", configured minVersion [").append(this._minVersion).append("]");
                err.append(", reported supported versions [").append(versions).append("]");
                LOG.warn(err.toString(), new Object[0]);
                throw new HttpException(400, "Unsupported websocket version specification");
            }
        }
        this.addConnection((WebSocketServletConnection)((Object)connection));
        connection.getConnection().setMaxBinaryMessageSize(this._maxBinaryMessageSize);
        connection.getConnection().setMaxTextMessageSize(this._maxTextMessageSize);
        connection.handshake(request, response, protocol);
        response.flushBuffer();
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getHeaderBuffer());
        connection.fillBuffersFrom(((HttpParser)http.getParser()).getBodyBuffer());
        LOG.debug("Websocket upgrade {} {} {} {}", request.getRequestURI(), draft, protocol, connection);
        request.setAttribute("org.eclipse.jetty.io.Connection", connection);
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            String origin = request.getHeader("Origin");
            if (origin == null) {
                origin = request.getHeader("Sec-WebSocket-Origin");
            }
            if (!this._acceptor.checkOrigin(request, origin)) {
                response.sendError(403);
                return false;
            }
            WebSocket websocket = null;
            Enumeration<String> protocols = request.getHeaders("Sec-WebSocket-Protocol");
            String protocol = null;
            block0: while (protocol == null && protocols != null && protocols.hasMoreElements()) {
                String candidate = protocols.nextElement();
                for (String p : this.parseProtocols(candidate)) {
                    websocket = this._acceptor.doWebSocketConnect(request, p);
                    if (websocket == null) continue;
                    protocol = p;
                    continue block0;
                }
            }
            if (websocket == null && (websocket = this._acceptor.doWebSocketConnect(request, null)) == null) {
                response.sendError(503);
                return false;
            }
            this.upgrade(request, response, websocket, protocol);
            return true;
        }
        return false;
    }

    public List<Extension> initExtensions(List<String> requested, int maxDataOpcodes, int maxControlOpcodes, int maxReservedBits) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String rExt : requested) {
            QuotedStringTokenizer tok = new QuotedStringTokenizer(rExt, ";");
            String extName = tok.nextToken().trim();
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tok.hasMoreTokens()) {
                QuotedStringTokenizer nv = new QuotedStringTokenizer(tok.nextToken().trim(), "=");
                String name = nv.nextToken().trim();
                String value = nv.hasMoreTokens() ? nv.nextToken().trim() : null;
                parameters.put(name, value);
            }
            Extension extension = this.newExtension(extName);
            if (extension == null || !extension.init(parameters)) continue;
            LOG.debug("add {} {}", extName, parameters);
            extensions.add(extension);
        }
        LOG.debug("extensions={}", extensions);
        return extensions;
    }

    private Extension newExtension(String name) {
        try {
            Class<? extends Extension> extClass = this._extensionClasses.get(name);
            if (extClass != null) {
                return extClass.newInstance();
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return null;
    }

    protected boolean addConnection(WebSocketServletConnection connection) {
        return this.isRunning() && this.connections.add(connection);
    }

    protected boolean removeConnection(WebSocketServletConnection connection) {
        return this.connections.remove(connection);
    }

    protected void closeConnections() {
        for (WebSocketServletConnection connection : this.connections) {
            connection.shutdown();
        }
    }

    public static interface Acceptor {
        public WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);

        public boolean checkOrigin(HttpServletRequest var1, String var2);
    }
}

