/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hasor.rsf.utils.NetworkUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterAddress {
    protected static Logger logger = LoggerFactory.getLogger(InterAddress.class);
    public static final String DEFAULT_SECHMA = "rsf";
    private final String sechma;
    private final String formUnit;
    private final String hostAddress;
    private final int hostPort;
    private final String hostSchema;

    public InterAddress(String newAddressURL) throws URISyntaxException {
        this(new URI(newAddressURL));
    }

    public InterAddress(URI newAddressURL) {
        if (!InterAddress.checkFormat(newAddressURL)) {
            throw new IllegalStateException(newAddressURL + " format error.");
        }
        String formPath = newAddressURL.getPath();
        if (formPath.startsWith("/")) {
            formPath = formPath.substring(1);
        }
        this.sechma = newAddressURL.getScheme().toLowerCase();
        this.formUnit = formPath.split("/")[0];
        this.hostAddress = newAddressURL.getHost();
        this.hostPort = newAddressURL.getPort();
        this.hostSchema = String.format("%s://%s:%s/%s", this.sechma, this.hostAddress, this.hostPort, this.formUnit);
    }

    public InterAddress(String hostAddress, int hostPort, String formUnit) {
        this(DEFAULT_SECHMA, hostAddress, hostPort, formUnit);
    }

    public InterAddress(String sechma, String hostAddress, int hostPort, String formUnit) {
        this.sechma = Objects.requireNonNull(sechma, "sechma is null.").toLowerCase();
        this.formUnit = Objects.requireNonNull(formUnit, "formUnit is null.");
        this.hostAddress = Objects.requireNonNull(hostAddress, "hostAddress is null.");
        this.hostPort = hostPort;
        this.hostSchema = String.format("%s://%s:%s/%s", this.sechma, this.hostAddress, this.hostPort, this.formUnit);
    }

    public String getSechma() {
        return this.sechma;
    }

    public String getFormUnit() {
        return this.formUnit;
    }

    public String getHost() {
        if ("local".equalsIgnoreCase(this.hostAddress)) {
            List<String> localIpAddr = NetworkUtils.localIpAddr();
            if (localIpAddr.isEmpty()) {
                try {
                    return InetAddress.getLocalHost().getHostName();
                }
                catch (Exception e) {
                    return "localhost";
                }
            }
            return localIpAddr.get(0);
        }
        return this.hostAddress;
    }

    public String getIp() throws UnknownHostException {
        return InetAddress.getByName(this.getHost()).getHostAddress();
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getHostPort() {
        return this.getHost() + ":" + this.getPort();
    }

    public String getIpPort() throws UnknownHostException {
        return this.getIp() + ":" + this.getPort();
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.getSechma(), null, this.getHost(), this.getPort(), "/" + this.formUnit, null, null);
    }

    public String toHostSchema() {
        return this.hostSchema;
    }

    public InetSocketAddress toSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(this.getIp(), this.getPort());
    }

    public boolean equals(Object obj) {
        String diffURI = "";
        if (obj instanceof InterAddress) {
            diffURI = ((InterAddress)obj).toHostSchema();
            return diffURI.equalsIgnoreCase(this.toHostSchema());
        }
        return false;
    }

    public boolean equalsHost(InterAddress evalResult) throws UnknownHostException {
        return evalResult != null && this.equalsHost(evalResult.getIpPort());
    }

    public boolean equalsHost(String evalResult) throws UnknownHostException {
        return evalResult != null && this.getIpPort().equals(evalResult);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formUnit == null ? 0 : this.formUnit.hashCode());
        result = 31 * result + (this.formUnit == null ? 0 : this.formUnit.hashCode());
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + this.hostAddress.hashCode();
        result = 31 * result + this.hostPort;
        return result;
    }

    public String toString() {
        return this.toHostSchema();
    }

    public static boolean checkFormat(URI serviceURL) {
        if (serviceURL == null) {
            return false;
        }
        if (!StringUtils.isBlank((String)serviceURL.getHost()) && serviceURL.getPort() != 0) {
            if (StringUtils.isBlank((String)serviceURL.getPath())) {
                return false;
            }
            String REG = "[A-Za-z0-9_\\.]+";
            Matcher mat = Pattern.compile("/(" + REG + ")").matcher(serviceURL.getPath());
            mat.find();
            String formUnit = mat.group(1);
            if (!StringUtils.isBlank((String)formUnit)) {
                return Pattern.matches(REG, formUnit);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("'{}' rsfAddress format error.", (Object)serviceURL);
        }
        return false;
    }
}

