/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.address.AddressTypeEnum;
import net.hasor.rsf.address.FlowControlRef;
import net.hasor.rsf.address.InnerInvalidInfo;
import net.hasor.rsf.address.RouteTypeEnum;
import net.hasor.rsf.address.RuleRef;
import net.hasor.rsf.address.route.flowcontrol.unit.UnitFlowControl;
import net.hasor.rsf.utils.IOUtils;
import net.hasor.rsf.utils.ZipUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBucket
extends Observable {
    protected static final Logger addressLogger = LoggerFactory.getLogger((String)"rsf-address");
    protected static final Logger logger = LoggerFactory.getLogger(AddressBucket.class);
    private final RsfSettings rsfSettings;
    private final RsfEnvironment rsfEnvironment;
    private volatile FlowControlRef flowControlRef;
    private volatile RuleRef ruleRef;
    private final String serviceID;
    private final String unitName;
    private final List<InterAddress> allAddressList;
    private final List<InterAddress> staticAddressList;
    private ConcurrentMap<InterAddress, InnerInvalidInfo> invalidAddresses;
    private List<InterAddress> localUnitAddresses;
    private List<InterAddress> availableAddresses;

    public AddressBucket(String serviceID, RsfEnvironment rsfEnvironment) {
        this.rsfSettings = rsfEnvironment.getSettings();
        this.rsfEnvironment = rsfEnvironment;
        this.flowControlRef = FlowControlRef.defaultRef(rsfEnvironment);
        this.ruleRef = new RuleRef(null);
        this.serviceID = serviceID;
        this.unitName = this.rsfSettings.getUnitName();
        this.allAddressList = new CopyOnWriteArrayList<InterAddress>();
        this.staticAddressList = new CopyOnWriteArrayList<InterAddress>();
        this.invalidAddresses = new ConcurrentHashMap<InterAddress, InnerInvalidInfo>();
        this.localUnitAddresses = new ArrayList<InterAddress>();
        this.availableAddresses = new ArrayList<InterAddress>();
        this.refreshAddress();
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public FlowControlRef getFlowControlRef() {
        return this.flowControlRef;
    }

    public RuleRef getRuleRef() {
        return this.ruleRef;
    }

    public synchronized List<InterAddress> getAllAddresses() {
        return new ArrayList<InterAddress>(this.allAddressList);
    }

    public synchronized List<InterAddress> getAvailableAddresses() {
        return new ArrayList<InterAddress>(this.availableAddresses);
    }

    public synchronized List<InterAddress> getInvalidAddresses() {
        return new ArrayList<InterAddress>(this.invalidAddresses.keySet());
    }

    public synchronized List<InterAddress> getLocalUnitAddresses() {
        return this.localUnitAddresses;
    }

    public void newAddress(Collection<InterAddress> newHostSet, AddressTypeEnum type) {
        if (addressLogger.isInfoEnabled()) {
            StringBuilder strBuffer = new StringBuilder();
            for (InterAddress addr : newHostSet) {
                strBuffer.append(addr.toHostSchema());
                strBuffer.append(",");
            }
            addressLogger.info("newAddress({}) -> {}, [{}].", new Object[]{this.serviceID, type.name(), strBuffer});
        }
        if (newHostSet == null || newHostSet.isEmpty()) {
            logger.warn("address({}) -> newAddress, newHostList is empty. type is {}", (Object)this.serviceID, (Object)type.name());
            return;
        }
        ArrayList<InterAddress> newAddress = new ArrayList<InterAddress>();
        ArrayList<InterAddress> newStaticAddress = new ArrayList<InterAddress>();
        ArrayList<InterAddress> toAvailable = new ArrayList<InterAddress>();
        for (InterAddress newHost : newHostSet) {
            if (newHost == null) continue;
            boolean doAdd = true;
            for (InterAddress hasAddress : this.allAddressList) {
                if (!newHost.equals(hasAddress)) continue;
                doAdd = false;
                break;
            }
            for (InterAddress hasAddress : this.invalidAddresses.keySet()) {
                if (!newHost.equals(hasAddress)) continue;
                toAvailable.add(newHost);
            }
            if (!doAdd) continue;
            if (AddressTypeEnum.Static.equals((Object)type)) {
                newStaticAddress.add(newHost);
            }
            newAddress.add(newHost);
        }
        this.allAddressList.addAll(newAddress);
        this.staticAddressList.addAll(newStaticAddress);
        for (InterAddress hasAddress : toAvailable) {
            this.invalidAddresses.remove(hasAddress);
        }
        this.refreshAvailableAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidAddress(InterAddress newInvalid, long timeout) {
        if (this.staticAddressList.contains(newInvalid)) {
            addressLogger.info("invalidAddress({}) -> targetAddress ={} ,addr is static.", (Object)this.serviceID, (Object)newInvalid);
            return;
        }
        if (!this.allAddressList.contains(newInvalid)) {
            addressLogger.warn("invalidAddress({}) -> targetAddress ={} ,addr is not exist.", (Object)this.serviceID, (Object)newInvalid);
            return;
        }
        InnerInvalidInfo invalidInfo = (InnerInvalidInfo)this.invalidAddresses.get(newInvalid);
        invalidInfo = this.invalidAddresses.putIfAbsent(newInvalid, new InnerInvalidInfo(timeout));
        if (invalidInfo != null) {
            addressLogger.info("invalidAddress({}) -> targetAddress ={} ,timeout ={}.", new Object[]{this.serviceID, newInvalid, timeout});
            invalidInfo.invalid(timeout);
        } else {
            try {
                AddressBucket addressBucket = this;
                synchronized (addressBucket) {
                    this.refreshAvailableAddress();
                }
            }
            catch (Exception e) {
                logger.error("address({}) -> invalid Address error -> {}.", new Object[]{this.serviceID, e.getMessage(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddress(InterAddress address) {
        if (!this.allAddressList.contains(address)) {
            addressLogger.warn("removeAddress({}) -> targetAddress ={} ,addr is not exist.", (Object)this.serviceID, (Object)address);
            return;
        }
        addressLogger.info("removeAddress({}) -> targetAddress ={}.", (Object)this.serviceID, (Object)address);
        this.allAddressList.remove(address);
        this.staticAddressList.remove(address);
        this.invalidAddresses.remove(address);
        AddressBucket addressBucket = this;
        synchronized (addressBucket) {
            this.refreshAvailableAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAddress() {
        AddressBucket addressBucket = this;
        synchronized (addressBucket) {
            this.refreshAvailableAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAddressToNew(List<InterAddress> addressList) {
        if (addressList == null || addressList.isEmpty()) {
            return;
        }
        AddressBucket addressBucket = this;
        synchronized (addressBucket) {
            if (addressLogger.isInfoEnabled()) {
                StringBuilder strBuffer = new StringBuilder();
                for (InterAddress addr : addressList) {
                    strBuffer.append(addr.toHostSchema());
                    strBuffer.append(",");
                }
                addressLogger.info("refreshAddressToNew({}) -> {}.", (Object)this.serviceID, (Object)strBuffer);
            }
            this.allAddressList.clear();
            this.allAddressList.addAll(addressList);
            this.invalidAddresses.clear();
            this.refreshAvailableAddress();
        }
    }

    private void refreshAvailableAddress() {
        ArrayList<InterAddress> availableList = new ArrayList<InterAddress>();
        for (InterAddress addressInfo : this.allAddressList) {
            InnerInvalidInfo info;
            boolean doAdd = true;
            for (InterAddress invalid : this.invalidAddresses.keySet()) {
                if (!addressInfo.equals(invalid)) continue;
                doAdd = false;
                break;
            }
            if ((info = (InnerInvalidInfo)this.invalidAddresses.get(addressInfo)) != null && info.reTry()) {
                doAdd = true;
            }
            if (!doAdd) continue;
            availableList.add(addressInfo);
        }
        List<InterAddress> unitList = availableList;
        if (this.flowControlRef != null && this.flowControlRef.unitFlowControl != null) {
            UnitFlowControl unitFlowControl = this.flowControlRef.unitFlowControl;
            unitList = unitFlowControl.siftUnitAddress(this.unitName, availableList);
            if (unitList == null || unitList.isEmpty()) {
                unitList = availableList;
            }
            if (!unitFlowControl.isLocalUnit(availableList.size(), unitList.size())) {
                unitList = availableList;
            }
        }
        if (addressLogger.isInfoEnabled() && addressLogger.isInfoEnabled()) {
            StringBuilder strBuffer1 = new StringBuilder();
            for (InterAddress addr : availableList) {
                strBuffer1.append(addr.toHostSchema());
                strBuffer1.append(",");
            }
            addressLogger.info("refreshAvailableAddress({}) -> availableList =[{}].", (Object)this.serviceID, (Object)strBuffer1);
            StringBuilder strBuffer2 = new StringBuilder();
            for (InterAddress addr : unitList) {
                strBuffer2.append(addr.toHostSchema());
                strBuffer2.append(",");
            }
            addressLogger.info("refreshAvailableAddress({}) -> unitList =[{}].", (Object)this.serviceID, (Object)strBuffer2);
        }
        this.availableAddresses = availableList;
        this.localUnitAddresses = unitList;
        this.notifyObservers(this);
    }

    public boolean updateFlowControl(String flowControl) {
        if (StringUtils.isBlank((String)flowControl)) {
            return false;
        }
        FlowControlRef newRef = FlowControlRef.newRef(this.rsfEnvironment, this.flowControlRef);
        newRef.updateFlowControl(flowControl);
        this.flowControlRef = newRef;
        this.refreshAddress();
        return true;
    }

    public boolean updateRoute(RouteTypeEnum routeType, String script) {
        RuleRef newRuleRef = new RuleRef(this.ruleRef);
        boolean updated = RouteTypeEnum.updateScript(routeType, script, newRuleRef);
        if (!updated) {
            logger.warn("address({}) -> update rules -> no change.", (Object)this.serviceID);
            return false;
        }
        logger.info("address({}) -> update rules -> update ok", (Object)this.serviceID);
        this.ruleRef = newRuleRef;
        this.refreshAddress();
        return true;
    }

    public String toString() {
        return "AddressBucket - " + this.getServiceID() + " ,unit = " + this.unitName + " ,allAddress size = " + this.allAddressList.size();
    }

    public boolean saveToZip(OutputStream outStream) throws IOException {
        RuleRef ruleRef;
        FlowControlRef flowControlRef;
        boolean toSave = false;
        ZipOutputStream zipStream = new ZipOutputStream(outStream);
        zipStream.setComment("this config of " + this.getServiceID());
        if (!this.allAddressList.isEmpty()) {
            toSave = true;
            StringBuilder strLogs = new StringBuilder();
            StringWriter strWriter = new StringWriter();
            BufferedWriter bfwriter = new BufferedWriter(strWriter);
            for (InterAddress inter : this.allAddressList) {
                if (this.staticAddressList.contains(inter)) {
                    strLogs.append(AddressTypeEnum.Static.getShortType());
                    bfwriter.append(AddressTypeEnum.Static.getShortType());
                } else {
                    strLogs.append(AddressTypeEnum.Dynamic.getShortType());
                    bfwriter.append(AddressTypeEnum.Dynamic.getShortType());
                }
                strLogs.append(inter.toString());
                strLogs.append(" , ");
                bfwriter.write(inter.toString());
                bfwriter.newLine();
            }
            bfwriter.flush();
            logger.info("bucket save list -> {}", (Object)strLogs.toString());
            try {
                String comment = "the address List of [" + this.serviceID + "] service.";
                ZipUtils.writeEntry(zipStream, strWriter.toString(), "address.sal", comment);
                logger.info("bucket save to entry -> {} ,finish.", (Object)this.serviceID);
            }
            catch (Exception e) {
                logger.error("bucket save to entry -> {} ,error -> {}", new Object[]{this.serviceID, e.getMessage(), e});
            }
        }
        if ((flowControlRef = this.flowControlRef) != null && StringUtils.isNotBlank((String)flowControlRef.flowControlScript)) {
            try {
                toSave = true;
                String comment = "the flowControlRef of [" + this.serviceID + "] service.";
                ZipUtils.writeEntry(zipStream, flowControlRef.flowControlScript, "flow-control.xml", comment);
                logger.info("flowControlRef save to entry -> {} ,finish.", (Object)this.serviceID);
            }
            catch (Exception e) {
                logger.error("flowControlRef save to entry -> {} ,error -> {}", new Object[]{this.serviceID, e.getMessage(), e});
            }
        }
        if ((ruleRef = this.ruleRef) != null) {
            String script;
            String comment;
            if (StringUtils.isBlank((String)ruleRef.getServiceLevel().getScript())) {
                try {
                    toSave = true;
                    comment = "the ServiceLevelScript of [" + this.serviceID + "] service.";
                    script = ruleRef.getServiceLevel().getScript();
                    ZipUtils.writeEntry(zipStream, script, "service-level.groovy", comment);
                    logger.info("ServiceLevelScript save to entry -> {} ,finish.", (Object)this.serviceID);
                }
                catch (Exception e) {
                    logger.error("ServiceLevelScript save to entry -> {} ,error -> {}", new Object[]{this.serviceID, e.getMessage(), e});
                }
            }
            if (StringUtils.isBlank((String)ruleRef.getMethodLevel().getScript())) {
                try {
                    toSave = true;
                    comment = "the MethodLevelScript of [" + this.serviceID + "] service.";
                    script = ruleRef.getMethodLevel().getScript();
                    ZipUtils.writeEntry(zipStream, script, "method-level.groovy", comment);
                    logger.info("MethodLevelScript save to entry -> {} ,finish.", (Object)this.serviceID);
                }
                catch (Exception e) {
                    logger.error("MethodLevelScript save to entry -> {} ,error -> {}", new Object[]{this.serviceID, e.getMessage(), e});
                }
            }
            if (StringUtils.isBlank((String)ruleRef.getArgsLevel().getScript())) {
                try {
                    toSave = true;
                    comment = "the ArgsLevelScript of [" + this.serviceID + "] service.";
                    script = ruleRef.getArgsLevel().getScript();
                    ZipUtils.writeEntry(zipStream, script, "args-level.groovy", comment);
                    logger.info("ArgsLevelScript save to entry -> {} ,finish.", (Object)this.serviceID);
                }
                catch (Exception e) {
                    logger.error("ArgsLevelScript save to entry -> {} ,error -> {}", new Object[]{this.serviceID, e.getMessage(), e});
                }
            }
        }
        if (toSave) {
            zipStream.finish();
            zipStream.closeEntry();
        }
        return toSave;
    }

    public void readFromZip(InputStream inStream) throws IOException {
        String scriptBody;
        ByteArrayInputStream dataIn;
        List dataBody;
        ZipInputStream zipStream = new ZipInputStream(inStream);
        HashMap<String, byte[]> dataMaps = new HashMap<String, byte[]>();
        ZipEntry zipEntry = null;
        while ((zipEntry = zipStream.getNextEntry()) != null) {
            ByteArrayOutputStream outArray = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)zipStream, (OutputStream)outArray);
            dataMaps.put(zipEntry.getName(), outArray.toByteArray());
        }
        try {
            if (dataMaps.containsKey("address.sal") && (dataBody = IOUtils.readLines((InputStream)(dataIn = new ByteArrayInputStream((byte[])dataMaps.get("address.sal"))), (String)"UTF-8")) != null && !dataBody.isEmpty()) {
                logger.info("service {} read address form stream", (Object)this.serviceID);
                StringBuilder strBuffer = new StringBuilder();
                ArrayList<InterAddress> staticNewHostSet = new ArrayList<InterAddress>();
                ArrayList<InterAddress> dynamicNewHostSet = new ArrayList<InterAddress>();
                for (String line : dataBody) {
                    if (StringUtils.isBlank((String)line) || line.startsWith("#")) continue;
                    try {
                        if (line.startsWith(AddressTypeEnum.Static.getShortType())) {
                            staticNewHostSet.add(new InterAddress(line.substring(2)));
                            strBuffer.append(line);
                            strBuffer.append(" , ");
                            continue;
                        }
                        if (!line.startsWith(AddressTypeEnum.Dynamic.getShortType())) continue;
                        dynamicNewHostSet.add(new InterAddress(line.substring(2)));
                        strBuffer.append(line);
                        strBuffer.append(" , ");
                    }
                    catch (URISyntaxException e) {
                        logger.info("read address '{}' has URISyntaxException.", (Object)line);
                    }
                }
                logger.info("bucket read list -> {}", (Object)strBuffer.toString());
                this.newAddress(staticNewHostSet, AddressTypeEnum.Static);
                this.newAddress(dynamicNewHostSet, AddressTypeEnum.Dynamic);
            }
        }
        catch (Throwable e) {
            logger.error("recoveryConfig address,failed-> serviceID ={} message={}.", new Object[]{this.serviceID, e.getMessage(), e});
        }
        try {
            String flowControl;
            if (dataMaps.containsKey("flow-control.xml") && (dataBody = IOUtils.readLines((InputStream)(dataIn = new ByteArrayInputStream((byte[])dataMaps.get("flow-control.xml"))), (String)"UTF-8")) != null && !dataBody.isEmpty() && StringUtils.isNotBlank((String)(flowControl = StringUtils.join((Object[])dataBody.toArray(), (String)"\n")))) {
                this.updateFlowControl(flowControl);
            }
        }
        catch (Throwable e) {
            logger.error("recoveryConfig flowControl,failed-> serviceID ={} message={}.", new Object[]{this.serviceID, e.getMessage(), e});
        }
        try {
            if (dataMaps.containsKey("service-level.groovy") && (dataBody = IOUtils.readLines((InputStream)(dataIn = new ByteArrayInputStream((byte[])dataMaps.get("service-level.groovy"))), (String)"UTF-8")) != null && !dataBody.isEmpty()) {
                scriptBody = StringUtils.join((Object[])dataBody.toArray(), (String)"\n");
                this.updateRoute(RouteTypeEnum.ServiceLevel, scriptBody);
            }
        }
        catch (Throwable e) {
            logger.error("recoveryConfig serviceRoute,failed-> serviceID ={} message={}.", new Object[]{this.serviceID, e.getMessage(), e});
        }
        try {
            if (dataMaps.containsKey("method-level.groovy") && (dataBody = IOUtils.readLines((InputStream)(dataIn = new ByteArrayInputStream((byte[])dataMaps.get("method-level.groovy"))), (String)"UTF-8")) != null && !dataBody.isEmpty()) {
                scriptBody = StringUtils.join((Object[])dataBody.toArray(), (String)"\n");
                this.updateRoute(RouteTypeEnum.MethodLevel, scriptBody);
            }
        }
        catch (Throwable e) {
            logger.error("recoveryConfig methodRoute,failed-> serviceID ={} message={}.", new Object[]{this.serviceID, e.getMessage(), e});
        }
        try {
            if (dataMaps.containsKey("args-level.groovy") && (dataBody = IOUtils.readLines((InputStream)(dataIn = new ByteArrayInputStream((byte[])dataMaps.get("args-level.groovy"))), (String)"UTF-8")) != null && !dataBody.isEmpty()) {
                scriptBody = StringUtils.join((Object[])dataBody.toArray(), (String)"\n");
                this.updateRoute(RouteTypeEnum.ArgsLevel, scriptBody);
            }
        }
        catch (Throwable e) {
            logger.error("recoveryConfig argsRoute,failed-> serviceID ={} message={}.", new Object[]{this.serviceID, e.getMessage(), e});
        }
    }
}

