/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address.route.flowcontrol.speed;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QoSBucket {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_RATE = 50;
    private static final int DEFAULT_PEAK = 100;
    private static final int DEFAULT_TIMEWINDOW = 1000;
    private int rate;
    private int peak;
    private int timeWindow;
    private AtomicInteger tokens;
    private volatile long lastRefreshTime;
    private volatile double leftDouble;

    public QoSBucket() {
        this(50, 100, 1000);
    }

    public QoSBucket(int rate, int peak, int timeWindow) {
        this.rate = rate;
        this.peak = peak;
        this.timeWindow = timeWindow;
        double initialToken = (double)(rate * timeWindow) / 1000.0;
        this.tokens = initialToken >= 1.0 ? new AtomicInteger((int)initialToken) : new AtomicInteger(1);
        this.leftDouble = initialToken - Math.floor(initialToken);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    public boolean check() {
        long now = System.currentTimeMillis();
        if (now > this.lastRefreshTime + (long)this.timeWindow) {
            int currentValue = this.tokens.get();
            double interval = (double)(now - this.lastRefreshTime) / 1000.0;
            double addedDouble = interval * (double)this.rate;
            int added = (int)addedDouble;
            if (added > 0) {
                double addedPlusDouble;
                int addPlus;
                int newValue;
                int n = newValue = (newValue = currentValue + (added += (addPlus = (int)(addedPlusDouble = this.leftDouble + (addedDouble - (double)added))))) > currentValue && newValue < this.peak ? newValue : this.peak;
                if (this.tokens.compareAndSet(currentValue, newValue)) {
                    this.lastRefreshTime = now;
                    this.leftDouble = addedPlusDouble - (double)addPlus;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[QoSBucket] Updated done: [{}] -> [{}], refresh time: {}.", new Object[]{currentValue, newValue, now});
                    }
                }
            }
        }
        int value = this.tokens.get();
        boolean flag = false;
        while (value > 0 && !flag) {
            flag = this.tokens.compareAndSet(value, value - 1);
            value = this.tokens.get();
        }
        if (this.logger.isDebugEnabled() && !flag) {
            this.logger.debug("QoSBucket: get token failed, tokens[" + this.tokens.get() + "]");
        }
        return flag;
    }

    public String toString() {
        return "QoSBucket [tokens=" + this.tokens + ", rate=" + this.rate + ", peak=" + this.peak + ", timeWindow=" + this.timeWindow + "]";
    }

    public boolean validate() {
        if (this.rate <= 0 || this.peak <= 0 || this.timeWindow < 1) {
            return false;
        }
        return !((float)this.peak < (float)(this.rate * this.timeWindow) / 1000.0f);
    }
}

