/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address.route.flowcontrol.unit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.core.Settings;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.address.route.rule.AbstractRule;
import net.hasor.utils.MatchUtils;

public class UnitFlowControl
extends AbstractRule {
    private float threshold;
    private List<String> exclusions;

    @Override
    public void parseControl(Settings settings) {
        this.enable(settings.getBoolean("flowControl.enable"));
        this.threshold = settings.getFloat("flowControl.threshold").floatValue();
        String exclusions = settings.getString("flowControl.exclusions");
        this.exclusions = Arrays.asList(exclusions.split(","));
    }

    public float getThreshold() {
        return this.threshold;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public boolean isLocalUnit(int allAmount, int localAmount) {
        if (localAmount == 0 || !this.enable()) {
            return false;
        }
        float value = ((float)localAmount + 0.0f) / (float)allAmount;
        return value >= this.getThreshold();
    }

    public List<InterAddress> siftUnitAddress(String unitName, List<InterAddress> address) {
        if (address == null || address.isEmpty()) {
            return null;
        }
        ArrayList<InterAddress> local = new ArrayList<InterAddress>();
        List<String> exclusions = this.getExclusions();
        for (InterAddress inter : address) {
            boolean appendMark = false;
            if (exclusions != null && !exclusions.isEmpty()) {
                String hostIP = inter.getHost();
                for (String ipPattern : exclusions) {
                    if (!MatchUtils.matchWild((String)ipPattern, (String)hostIP)) continue;
                    appendMark = true;
                    break;
                }
            }
            if (!appendMark) {
                appendMark = unitName.equalsIgnoreCase(inter.getFormUnit());
            }
            if (!appendMark) continue;
            local.add(inter);
        }
        return local;
    }
}

