/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address.route.rule;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import net.hasor.core.Settings;
import net.hasor.core.setting.InputStreamSettings;
import net.hasor.core.setting.SettingNode;
import net.hasor.core.setting.provider.StreamType;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.address.route.rule.AbstractRule;
import net.hasor.rsf.address.route.rule.Rule;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleParser {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Class<?>> ruleTypeMap = new HashMap();

    public RuleParser(RsfEnvironment rsfEnvironment) {
        RsfSettings rsfSettings = rsfEnvironment.getSettings();
        SettingNode[] flowControlNodes = rsfSettings.getNodeArray("hasor.rsfConfig.route.flowcontrol");
        if (flowControlNodes != null) {
            for (SettingNode node : flowControlNodes) {
                SettingNode[] ruleTypes;
                for (SettingNode ruleType : ruleTypes = node.getSubNodes()) {
                    String ruleID = ruleType.getName().trim().toLowerCase();
                    String ruleClassName = ruleType.getValue().trim();
                    try {
                        Class<?> ruleClass = rsfEnvironment.getClassLoader().loadClass(ruleClassName);
                        this.ruleTypeMap.put(ruleID, ruleClass);
                    }
                    catch (Throwable e) {
                        this.logger.error("rule {} load type error -> {}", (Object)ruleID, (Object)e.getMessage());
                    }
                }
            }
        }
    }

    public Rule ruleSettings(String rawRoute) {
        if (StringUtils.isBlank((String)rawRoute) || !rawRoute.startsWith("<flowControl") || !rawRoute.endsWith("</flowControl>")) {
            this.logger.info("rule raw format error.");
            return null;
        }
        try {
            InputStreamSettings ruleSettings = new InputStreamSettings();
            ruleSettings.addReader((Reader)new StringReader("<xml>" + rawRoute + "</xml>"), StreamType.Xml);
            ruleSettings.loadSettings();
            return this.ruleSettings((Settings)ruleSettings);
        }
        catch (Exception e) {
            this.logger.error("rule raw format error. -> {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public Rule ruleSettings(Settings ruleSettings) {
        if (ruleSettings == null) {
            this.logger.info("ruleSettings is null.");
            return null;
        }
        AbstractRule ruleObject = null;
        try {
            String ruleID = ruleSettings.getString("flowControl.type");
            boolean ruleEnable = ruleSettings.getBoolean("flowControl.enable", Boolean.valueOf(false));
            if (StringUtils.isBlank((String)ruleID)) {
                this.logger.info("flowControl.type is null.");
                return null;
            }
            ruleID = ruleID.trim().toLowerCase();
            this.logger.info("process rule '{}' -> {}.", (Object)ruleID, (Object)ruleEnable);
            Class<?> ruleClass = this.ruleTypeMap.get(ruleID);
            if (ruleClass == null) {
                this.logger.info("rule type of '{}' is undefined.", (Object)ruleID);
                return null;
            }
            ruleObject = (AbstractRule)ruleClass.newInstance();
            ruleObject.setRouteID(ruleID);
            ruleObject.setRouteBody(ruleSettings.getNode("flowControl").toXml());
            ruleObject.enable(ruleEnable);
            ruleObject.parseControl(ruleSettings);
        }
        catch (Exception e) {
            this.logger.error("rule raw format error -> {}", (Object)e.getMessage(), (Object)e);
        }
        return ruleObject;
    }

    public String toString() {
        return "RuleParser Types:" + this.ruleTypeMap.keySet();
    }
}

