/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.bootstrap;

import java.util.EventListener;
import net.hasor.core.spi.ContextShutdownListener;
import net.hasor.core.spi.ContextStartListener;
import net.hasor.rsf.OnlineStatus;
import net.hasor.rsf.RsfApiBinder;
import net.hasor.rsf.RsfClient;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfModule;
import net.hasor.rsf.RsfPublisher;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.RsfResponse;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.RsfUpdater;
import net.hasor.rsf.filters.local.LocalPref;
import net.hasor.rsf.filters.online.OnlineRsfFilter;
import net.hasor.rsf.filters.thread.LocalWarpFilter;
import net.hasor.rsf.filters.thread.RsfRequestLocal;
import net.hasor.rsf.filters.thread.RsfResponseLocal;
import net.hasor.rsf.rpc.context.AbstractRsfContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RsfFrameworkModule
implements RsfModule {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void loadModule(RsfApiBinder apiBinder) throws Throwable {
        this.logger.info("rsf framework starting.");
        RsfEnvironment environment = apiBinder.getEnvironment();
        AbstractRsfContext rsfContext = new AbstractRsfContext(environment){};
        apiBinder.bindSpiListener(ContextStartListener.class, (EventListener)((Object)rsfContext));
        apiBinder.bindSpiListener(ContextShutdownListener.class, (EventListener)((Object)rsfContext));
        apiBinder.bindType(RsfSettings.class).toInstance((Object)environment.getSettings());
        apiBinder.bindType(RsfContext.class).toInstance((Object)rsfContext);
        apiBinder.bindType(OnlineStatus.class).toInstance((Object)rsfContext);
        apiBinder.bindType(RsfUpdater.class).toInstance((Object)rsfContext.getUpdater());
        apiBinder.bindType(RsfClient.class).toProvider(rsfContext::getRsfClient);
        apiBinder.bindType(RsfRequest.class).toInstance((Object)new RsfRequestLocal());
        apiBinder.bindType(RsfResponse.class).toInstance((Object)new RsfResponseLocal());
        RsfPublisher rsfPublisher = rsfContext.publisher();
        apiBinder.bindType(RsfPublisher.class).toInstance((Object)rsfPublisher);
        rsfPublisher.bindFilter("LocalPref", new LocalPref());
        rsfPublisher.bindFilter("LocalWarpFilter", new LocalWarpFilter());
        rsfPublisher.bindFilter("SecurityRsfFilter", new OnlineRsfFilter());
        this.logger.info("rsf framework init finish.");
    }
}

