/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.container;

import java.lang.annotation.Annotation;
import net.hasor.rsf.RsfService;
import net.hasor.rsf.RsfSettings;
import net.hasor.utils.StringUtils;

class AnnoRsfServiceValue
implements RsfService {
    private String serviceGroup = null;
    private String serviceName = null;
    private String serviceVersion = null;
    private int clientTimeout = 0;
    private String serializeType = null;

    public AnnoRsfServiceValue(RsfSettings rsfSettings, Class<?> serviceType) {
        RsfService serviceInfo = serviceType.getAnnotation(RsfService.class);
        if (serviceInfo != null) {
            if (!StringUtils.isBlank((String)serviceInfo.group())) {
                this.serviceGroup = serviceInfo.group();
            }
            if (!StringUtils.isBlank((String)serviceInfo.name())) {
                this.serviceName = serviceInfo.name();
            }
            if (!StringUtils.isBlank((String)serviceInfo.version())) {
                this.serviceVersion = serviceInfo.version();
            }
            if (!StringUtils.isBlank((String)serviceInfo.serializeType())) {
                this.serializeType = serviceInfo.serializeType();
            }
            if (serviceInfo.clientTimeout() > 0) {
                this.clientTimeout = serviceInfo.clientTimeout();
            }
        }
        if (StringUtils.isBlank((String)this.serviceGroup)) {
            this.serviceGroup = rsfSettings.getDefaultGroup();
        }
        if (StringUtils.isBlank((String)this.serviceName)) {
            this.serviceName = serviceType.getName();
        }
        if (StringUtils.isBlank((String)this.serviceVersion)) {
            this.serviceVersion = rsfSettings.getDefaultVersion();
        }
        if (StringUtils.isBlank((String)this.serializeType)) {
            this.serializeType = rsfSettings.getDefaultSerializeType();
        }
        if (this.clientTimeout < 1) {
            this.clientTimeout = rsfSettings.getDefaultTimeout();
        }
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return AnnoRsfServiceValue.class;
    }

    @Override
    public String name() {
        return this.serviceName;
    }

    @Override
    public String group() {
        return this.serviceGroup;
    }

    @Override
    public String version() {
        return this.serviceVersion;
    }

    @Override
    public int clientTimeout() {
        return this.clientTimeout;
    }

    @Override
    public String serializeType() {
        return this.serializeType;
    }
}

