/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.EventContext;
import net.hasor.rsf.RsfBindInfo;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.RsfPublisher;
import net.hasor.rsf.RsfService;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.address.AddressPool;
import net.hasor.rsf.address.RouteTypeEnum;
import net.hasor.rsf.container.ContextRsfBindBuilder;
import net.hasor.rsf.container.FilterDefine;
import net.hasor.rsf.container.ServiceDefine;
import net.hasor.rsf.domain.RsfException;
import net.hasor.rsf.domain.RsfServiceType;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsfBeanContainer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Supplier[] EMPTY_FILTER = new Supplier[0];
    private final ConcurrentMap<String, ServiceDefine<?>> serviceMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentMap<String, String>> aliasNameMap = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
    private final List<FilterDefine> filterList = new ArrayList<FilterDefine>();
    private final Object filterLock = new Object();
    private final ConcurrentMap<String, Supplier<RsfFilter>[]> filterCache = new ConcurrentHashMap<String, Supplier<RsfFilter>[]>();
    private final AddressPool addressPool;
    private AppContext appContext;

    public RsfBeanContainer(AddressPool addressPool) {
        this.addressPool = addressPool;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public Supplier<RsfFilter>[] getFilterProviders(String serviceID) {
        ServiceDefine info = (ServiceDefine)this.serviceMap.get(serviceID);
        if (info == null) {
            return EMPTY_FILTER;
        }
        Supplier[] result = (Supplier[])this.filterCache.get(serviceID);
        if (result == null) {
            List<FilterDefine> snapshotsList;
            LinkedList<String> cacheIds = new LinkedList<String>();
            HashMap<String, FilterDefine> cacheFilters = new HashMap<String, FilterDefine>();
            List<FilterDefine> publicList = this.filterList;
            if (!publicList.isEmpty()) {
                for (FilterDefine filterDefine : publicList) {
                    String filterID = filterDefine.filterID();
                    cacheFilters.put(filterID, filterDefine);
                    cacheIds.add(filterID);
                }
            }
            if ((snapshotsList = info.getFilterSnapshots()) != null && !snapshotsList.isEmpty()) {
                for (FilterDefine filter : snapshotsList) {
                    String filterID = filter.filterID();
                    cacheFilters.put(filterID, filter);
                    if (cacheIds.contains(filterID)) {
                        cacheIds.remove(filterID);
                    }
                    cacheIds.add(filterID);
                }
            }
            ArrayList<FilterDefine> arrayList = new ArrayList<FilterDefine>(cacheIds.size());
            for (String filterID : cacheIds) {
                FilterDefine define = (FilterDefine)cacheFilters.get(filterID);
                arrayList.add(define);
            }
            result = arrayList.toArray(new Supplier[0]);
            this.filterCache.put(serviceID, result);
        }
        return result;
    }

    public <T> Supplier<T> getProvider(RsfBindInfo<T> rsfBindInfo) {
        ServiceDefine info = (ServiceDefine)this.serviceMap.get(rsfBindInfo.getBindID());
        if (info == null) {
            return null;
        }
        Supplier target = info.getCustomerProvider();
        if (target != null) {
            return target;
        }
        return null;
    }

    public RsfBindInfo<?> getRsfBindInfo(String serviceID) {
        ServiceDefine info = (ServiceDefine)this.serviceMap.get(serviceID);
        if (info == null) {
            return null;
        }
        return info.getDomain();
    }

    public RsfBindInfo<?> getRsfBindInfo(String aliasType, String aliasName) {
        ConcurrentMap aliasNameMaps = (ConcurrentMap)this.aliasNameMap.get(aliasType);
        if (aliasNameMaps == null) {
            return null;
        }
        String serviceID = (String)aliasNameMaps.get(aliasName);
        if (serviceID == null) {
            return null;
        }
        return (RsfBindInfo)this.serviceMap.get(serviceID);
    }

    public <T> RsfBindInfo<T> getRsfBindInfo(Class<T> serviceType) {
        RsfSettings rsfSettings = this.addressPool.getRsfEnvironment().getSettings();
        String serviceGroup = rsfSettings.getDefaultGroup();
        String serviceName = serviceType.getName();
        String serviceVersion = rsfSettings.getDefaultVersion();
        RsfService serviceInfo = serviceType.getAnnotation(RsfService.class);
        if (serviceInfo != null) {
            if (!StringUtils.isBlank((String)serviceInfo.group())) {
                serviceGroup = serviceInfo.group();
            }
            if (!StringUtils.isBlank((String)serviceInfo.name())) {
                serviceName = serviceInfo.name();
            }
            if (!StringUtils.isBlank((String)serviceInfo.version())) {
                serviceVersion = serviceInfo.version();
            }
        }
        return this.getRsfBindInfo(serviceGroup, serviceName, serviceVersion);
    }

    public RsfBindInfo<?> getRsfBindInfo(String group, String name, String version) {
        String serviceID = "[" + group + "]" + name + "-" + version;
        return this.getRsfBindInfo(serviceID);
    }

    public List<String> getServiceIDs() {
        return new ArrayList<String>(this.serviceMap.keySet());
    }

    public List<String> getServiceIDs(String category) {
        ConcurrentMap aliasNameMaps = (ConcurrentMap)this.aliasNameMap.get(category);
        if (aliasNameMaps == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<String>(aliasNameMaps.keySet());
    }

    public RsfEnvironment getEnvironment() {
        return this.addressPool.getRsfEnvironment();
    }

    public RsfPublisher createPublisher(final RsfBeanContainer container, final RsfContext rsfContext) {
        return new ContextRsfBindBuilder(){

            @Override
            protected RsfBeanContainer getContainer() {
                return container;
            }

            @Override
            protected RsfContext getRsfContext() {
                return rsfContext;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFilter(FilterDefine define) {
        String filterID = Objects.requireNonNull(define.filterID());
        Object object = this.filterLock;
        synchronized (object) {
            for (FilterDefine filter : this.filterList) {
                if (!filterID.equals(filter.filterID())) continue;
                throw new IllegalStateException("repeate filterID :" + filterID);
            }
            this.filterList.add(define);
            this.filterCache.clear();
        }
    }

    public synchronized <T> boolean publishService(ServiceDefine<T> serviceDefine) {
        Map<RouteTypeEnum, String> scriptMap;
        String serviceID = serviceDefine.getDomain().getBindID();
        if (this.serviceMap.containsKey(serviceID)) {
            String serviceType = ((ServiceDefine)this.serviceMap.get(serviceID)).getDomain().getServiceType().name();
            String logMessage = "a " + serviceType + " of the same name already exists , serviceID -> " + serviceID;
            this.logger.error(logMessage);
            throw new IllegalStateException(logMessage);
        }
        this.logger.info("service to public, id= {}", (Object)serviceID);
        ServiceDefine<T> info = this.serviceMap.putIfAbsent(serviceID, serviceDefine);
        EventContext eventContext = this.addressPool.getRsfEnvironment().getEventContext();
        if (RsfServiceType.Provider == serviceDefine.getServiceType()) {
            if (serviceDefine.getCustomerProvider() == null) {
                throw new RsfException(403, "Provider Not set the implementation class.");
            }
            try {
                eventContext.fireSyncEvent("RsfEvent_ProviderService", serviceDefine);
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
        } else {
            try {
                eventContext.fireSyncEvent("RsfEvent_ConsumerService", serviceDefine);
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        Set<String> aliasTypes = serviceDefine.getAliasTypes();
        for (String aliasType : aliasTypes) {
            String aliasName;
            ConcurrentHashMap<String, String> aliasMap = (ConcurrentHashMap<String, String>)this.aliasNameMap.get(aliasType);
            if (aliasMap == null) {
                aliasMap = new ConcurrentHashMap<String, String>();
                this.aliasNameMap.putIfAbsent(aliasType, aliasMap);
            }
            if (StringUtils.isBlank((String)(aliasName = serviceDefine.getAliasName(aliasType)))) continue;
            aliasMap.putIfAbsent(aliasName, serviceID);
        }
        this.addressPool.appendStaticAddress(serviceID, serviceDefine.getAddressSet());
        String flowControl = serviceDefine.getFlowControl();
        if (StringUtils.isNotBlank((String)flowControl)) {
            this.addressPool.updateFlowControl(serviceID, flowControl);
        }
        if ((scriptMap = serviceDefine.getRouteScript()) != null && !scriptMap.isEmpty()) {
            for (Map.Entry<RouteTypeEnum, String> routeEnt : scriptMap.entrySet()) {
                this.addressPool.updateRoute(serviceID, routeEnt.getKey(), routeEnt.getValue());
            }
        }
        return true;
    }

    public synchronized boolean recoverService(String serviceID) {
        if (this.serviceMap.containsKey(serviceID)) {
            EventContext eventContext = this.getEnvironment().getEventContext();
            RsfBindInfo rsfBindInfo = (RsfBindInfo)this.serviceMap.get(serviceID);
            try {
                eventContext.fireSyncEvent("RsfEvent_DeleteService", (Object)rsfBindInfo);
            }
            catch (Throwable e) {
                this.logger.error(e.getMessage(), e);
            }
            this.serviceMap.remove(serviceID);
            for (Map.Entry aliasEntry : this.aliasNameMap.entrySet()) {
                ConcurrentMap aliasSet = (ConcurrentMap)aliasEntry.getValue();
                ArrayList toRemove = new ArrayList();
                for (Map.Entry entry : aliasSet.entrySet()) {
                    if (!serviceID.equals(entry.getValue())) continue;
                    toRemove.add(entry.getKey());
                }
                for (String key : toRemove) {
                    aliasSet.remove(key);
                }
            }
            return true;
        }
        return false;
    }

    public void lookUp(AppContext appContext) {
        this.appContext = appContext;
        List filterList = appContext.findBindingRegister(FilterDefine.class);
        for (BindInfo defile : filterList) {
            FilterDefine fd = (FilterDefine)appContext.getInstance(defile);
            if (fd == null) continue;
            this.publishFilter(fd);
        }
        List serviceList = appContext.findBindingRegister(ServiceDefine.class);
        for (BindInfo defile : serviceList) {
            ServiceDefine sd = (ServiceDefine)appContext.getInstance(defile);
            if (sd == null) continue;
            this.publishService(sd);
        }
        this.logger.info("lookUp finish.");
    }
}

