/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hessian.hessian.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ClassFactory {
    private static ArrayList<Allow> _staticAllowList;
    private static ArrayList<Allow> _staticDenyList;
    private ClassLoader _loader;
    private boolean _isWhitelist;
    private ArrayList<Allow> _allowList;

    ClassFactory(ClassLoader loader) {
        this._loader = loader;
    }

    public Class<?> load(String className) throws ClassNotFoundException {
        if (this.isAllow(className)) {
            return Class.forName(className, false, this._loader);
        }
        return HashMap.class;
    }

    private boolean isAllow(String className) {
        ArrayList<Allow> allowList = this._allowList;
        if (allowList == null) {
            Boolean isAllow = this.isAllow(_staticDenyList, className);
            if (isAllow != null) {
                return isAllow;
            }
            return true;
        }
        Boolean isAllow = this.isAllow(this._allowList, className);
        if (isAllow != null) {
            return isAllow;
        }
        isAllow = this.isAllow(_staticAllowList, className);
        if (isAllow != null) {
            return isAllow;
        }
        return !this._isWhitelist;
    }

    private Boolean isAllow(ArrayList<Allow> allowList, String className) {
        if (allowList == null) {
            return null;
        }
        int size = allowList.size();
        for (int i = 0; i < size; ++i) {
            Allow allow = allowList.get(i);
            Boolean isAllow = allow.allow(className);
            if (isAllow == null) continue;
            return isAllow;
        }
        return null;
    }

    public void setWhitelist(boolean isWhitelist) {
        this.initAllow();
        this._isWhitelist = isWhitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allow(String pattern) {
        this.initAllow();
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            this._allowList.add(new Allow(this.toPattern(pattern), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deny(String pattern) {
        this.initAllow();
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            this._allowList.add(new Allow(this.toPattern(pattern), false));
        }
    }

    private String toPattern(String pattern) {
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("*", ".*");
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllow() {
        ClassFactory classFactory = this;
        synchronized (classFactory) {
            if (this._allowList == null) {
                this._allowList = new ArrayList();
                this._isWhitelist = true;
            }
        }
    }

    static {
        ArrayList<Allow> blacklist = new ArrayList<Allow>();
        blacklist.add(new Allow("java\\.lang\\.Runtime", false));
        blacklist.add(new Allow("java\\.lang\\.Process", false));
        blacklist.add(new Allow("java\\.lang\\.System", false));
        blacklist.add(new Allow("java\\.lang\\.Thread", false));
        _staticAllowList = new ArrayList(blacklist);
        _staticAllowList.add(new Allow("java\\..+", true));
        _staticAllowList.add(new Allow("javax\\.management\\..+", true));
        _staticDenyList = new ArrayList(blacklist);
    }

    static class Allow {
        private Boolean _isAllow;
        private Pattern _pattern;

        private Allow(String pattern, boolean isAllow) {
            this._isAllow = isAllow;
            this._pattern = Pattern.compile(pattern);
        }

        Boolean allow(String className) {
            if (this._pattern.matcher(className).matches()) {
                return this._isAllow;
            }
            return null;
        }
    }
}

