/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.client;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.rsf.hprose.util.StrUtil;

public class CookieManager {
    private static final TimeZone utc = TimeZone.getTimeZone("UTC");
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>> container = new ConcurrentHashMap();

    private static int parseMonth(String str) {
        str = str.toLowerCase();
        switch (str.charAt(0) + str.charAt(1) + str.charAt(2) - 300) {
            case 13: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 20: {
                return 2;
            }
            case 23: {
                return 3;
            }
            case 27: {
                return 4;
            }
            case 33: {
                return 5;
            }
            case 31: {
                return 6;
            }
            case 17: {
                return 7;
            }
            case 28: {
                return 8;
            }
            case 26: {
                return 9;
            }
            case 39: {
                return 10;
            }
            case 0: {
                return 11;
            }
        }
        return 0;
    }

    private static Calendar parseCalendar(String str) {
        String[] time;
        int year;
        int month;
        int day;
        Calendar calendar = Calendar.getInstance(utc);
        if (str == null || str.length() == 0) {
            return calendar;
        }
        String[] datetime = StrUtil.split(str, ' ', 0);
        if (datetime[1].indexOf(45) > 0) {
            String[] date = StrUtil.split(datetime[1], '-', 0);
            day = Integer.parseInt(date[0]);
            month = CookieManager.parseMonth(date[1]);
            year = Integer.parseInt(date[2]);
            time = StrUtil.split(datetime[2], ':', 0);
        } else {
            day = Integer.parseInt(datetime[1]);
            month = CookieManager.parseMonth(datetime[2]);
            year = Integer.parseInt(datetime[3]);
            time = StrUtil.split(datetime[4], ':', 0);
        }
        int hour = Integer.parseInt(time[0]);
        int minute = Integer.parseInt(time[1]);
        int second = Integer.parseInt(time[2]);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar;
    }

    public synchronized void setCookie(List<String> cookieList, String host) {
        if (cookieList == null) {
            return;
        }
        int n = cookieList.size();
        for (int i = 0; i < n; ++i) {
            String cookieString = cookieList.get(i);
            if (cookieString.length() == 0) continue;
            String[] cookies = StrUtil.split(cookieString.trim(), ';', 0);
            ConcurrentHashMap<String, String> cookie = new ConcurrentHashMap<String, String>();
            String[] value = StrUtil.split(cookies[0].trim(), '=', 2);
            cookie.put("name", value[0]);
            if (value.length == 2) {
                cookie.put("value", value[1]);
            } else {
                cookie.put("value", "");
            }
            int m = cookies.length;
            for (int j = 1; j < m; ++j) {
                value = StrUtil.split(cookies[j].trim(), '=', 2);
                if (value.length == 2) {
                    cookie.put(value[0].toUpperCase(), value[1]);
                    continue;
                }
                cookie.put(value[0].toUpperCase(), "");
            }
            if (cookie.containsKey("PATH")) {
                String path = (String)cookie.get("PATH");
                if (path.charAt(0) == '\"') {
                    path = path.substring(1);
                }
                if (path.charAt(path.length() - 1) == '\"') {
                    path = path.substring(0, path.length() - 1);
                }
                cookie.put("PATH", path);
            } else {
                cookie.put("PATH", "/");
            }
            if (cookie.containsKey("DOMAIN")) {
                cookie.put("DOMAIN", ((String)cookie.get("DOMAIN")).toLowerCase());
            } else {
                cookie.put("DOMAIN", host);
            }
            if (!this.container.containsKey(cookie.get("DOMAIN"))) {
                this.container.put((String)cookie.get("DOMAIN"), new ConcurrentHashMap());
            }
            this.container.get(cookie.get("DOMAIN")).put((String)cookie.get("name"), cookie);
        }
    }

    public synchronized String getCookie(String host, String path, boolean secure) {
        StringBuilder cookies = new StringBuilder();
        for (Map.Entry<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>> entry : this.container.entrySet()) {
            String domain = entry.getKey();
            ConcurrentHashMap<String, ConcurrentHashMap<String, String>> cookieList = entry.getValue();
            if (!host.endsWith(domain)) continue;
            ArrayList<String> names = new ArrayList<String>(cookieList.size());
            for (Map.Entry<String, ConcurrentHashMap<String, String>> entry2 : cookieList.entrySet()) {
                ConcurrentHashMap<String, String> cookie = entry2.getValue();
                if (cookie.containsKey("EXPIRES") && Calendar.getInstance(utc).after(CookieManager.parseCalendar(cookie.get("EXPIRES")))) {
                    names.add(entry2.getKey());
                    continue;
                }
                if (!path.startsWith(cookie.get("PATH")) || (!secure || !cookie.containsKey("SECURE")) && cookie.containsKey("SECURE") || cookie.get("value").length() <= 0) continue;
                if (cookies.length() != 0) {
                    cookies.append("; ");
                }
                cookies.append(cookie.get("name")).append('=').append(cookie.get("value"));
            }
            int n = names.size();
            for (int i = 0; i < n; ++i) {
                this.container.get(domain).remove(names.get(i));
            }
        }
        return cookies.toString();
    }
}

