/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.common;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.rsf.hprose.common.HproseContext;
import net.hasor.rsf.hprose.common.HproseMethod;
import net.hasor.rsf.hprose.common.HproseResultMode;

public class HproseMethods {
    protected ConcurrentHashMap<String, ConcurrentHashMap<Integer, HproseMethod>> remoteMethods = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> methodNames = new ConcurrentHashMap();

    public HproseMethod get(String aliasName, int paramCount) {
        ConcurrentHashMap<Integer, HproseMethod> methods = this.remoteMethods.get(aliasName);
        if (methods == null) {
            return null;
        }
        return methods.get(paramCount);
    }

    public Collection<String> getAllNames() {
        return this.methodNames.values();
    }

    public int getCount() {
        return this.remoteMethods.size();
    }

    protected int getCount(Type[] paramTypes) {
        Class paramType;
        int i = paramTypes.length;
        if (i > 0 && paramTypes[i - 1] instanceof Class && (paramType = (Class)paramTypes[i - 1]).equals(HproseContext.class)) {
            --i;
        }
        return i;
    }

    public void addMethod(String aliasName, HproseMethod method) {
        ConcurrentHashMap<Object, Object> methods;
        String name = aliasName.toLowerCase();
        if (this.remoteMethods.containsKey(name)) {
            methods = this.remoteMethods.get(name);
        } else {
            methods = new ConcurrentHashMap();
            this.methodNames.put(name, aliasName);
        }
        if (!(!aliasName.equals("*") || method.paramTypes.length == 2 && method.paramTypes[0].equals(String.class) && method.paramTypes[1].equals(Object[].class))) {
            return;
        }
        int i = this.getCount(method.paramTypes);
        methods.put(i, method);
        this.remoteMethods.put(name, methods);
    }

    public void addMethod(Method method, Object obj, String aliasName) {
        this.addMethod(aliasName, new HproseMethod(method, obj));
    }

    public void addMethod(Method method, Object obj, String aliasName, HproseResultMode mode) {
        this.addMethod(aliasName, new HproseMethod(method, obj, mode));
    }

    public void addMethod(Method method, Object obj, String aliasName, boolean simple) {
        this.addMethod(aliasName, new HproseMethod(method, obj, simple));
    }

    public void addMethod(Method method, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.addMethod(aliasName, new HproseMethod(method, obj, mode, simple));
    }

    public void addMethod(Method method, Object obj, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethod(aliasName, new HproseMethod(method, obj, mode, simple, oneway));
    }

    public void addMethod(HproseMethod method) {
        this.addMethod(method.aliasName, method);
    }

    public void addMethod(Method method, Object obj) {
        this.addMethod(new HproseMethod(method, obj));
    }

    public void addMethod(Method method, Object obj, HproseResultMode mode) {
        this.addMethod(new HproseMethod(method, obj, mode));
    }

    public void addMethod(Method method, Object obj, boolean simple) {
        this.addMethod(new HproseMethod(method, obj, simple));
    }

    public void addMethod(Method method, Object obj, HproseResultMode mode, boolean simple) {
        this.addMethod(new HproseMethod(method, obj, mode, simple));
    }

    public void addMethod(Method method, Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethod(new HproseMethod(method, obj, mode, simple, oneway));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, mode));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, mode, simple, oneway));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, mode));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, mode, simple, oneway));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, obj, paramTypes));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, obj, paramTypes, mode));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, obj, paramTypes, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, obj, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, obj, paramTypes, mode, simple, oneway));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, type, paramTypes));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, type, paramTypes, mode));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, type, paramTypes, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, type, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.addMethod(new HproseMethod(methodName, type, paramTypes, mode, simple, oneway));
    }

    private void addMethod(String methodName, Object obj, Class<?> type, String aliasName, HproseMethodCreator creator) {
        Method[] methods;
        for (Method method : methods = type.getMethods()) {
            if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
            this.addMethod(aliasName, creator.create(method));
        }
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, String aliasName, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addMethod(methodName, obj, type, aliasName, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, String aliasName, final HproseResultMode mode, final boolean simple) {
        this.addMethod(methodName, obj, type, aliasName, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, String aliasName, final HproseResultMode mode) {
        this.addMethod(methodName, obj, type, aliasName, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, String aliasName, final boolean simple) {
        this.addMethod(methodName, obj, type, aliasName, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, String aliasName) {
        this.addMethod(methodName, obj, type, aliasName, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    public void addMethod(String methodName, Object obj, String aliasName) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName);
    }

    public void addMethod(String methodName, Object obj, String aliasName, HproseResultMode mode) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, mode);
    }

    public void addMethod(String methodName, Object obj, String aliasName, boolean simple) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, simple);
    }

    public void addMethod(String methodName, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, mode, simple);
    }

    public void addMethod(String methodName, Object obj, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, mode, simple, oneway);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName) {
        this.addMethod(methodName, null, type, aliasName);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, HproseResultMode mode) {
        this.addMethod(methodName, null, type, aliasName, mode);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, boolean simple) {
        this.addMethod(methodName, null, type, aliasName, simple);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, null, type, aliasName, mode, simple);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethod(methodName, null, type, aliasName, mode, simple, oneway);
    }

    private void addMethod(String methodName, Object obj, Class<?> type, HproseMethodCreator creator) {
        Method[] methods;
        for (Method method : methods = type.getMethods()) {
            if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
            this.addMethod(creator.create(method));
        }
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addMethod(methodName, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, final HproseResultMode mode, final boolean simple) {
        this.addMethod(methodName, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, final HproseResultMode mode) {
        this.addMethod(methodName, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type, final boolean simple) {
        this.addMethod(methodName, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    private void addMethod(String methodName, final Object obj, Class<?> type) {
        this.addMethod(methodName, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    public void addMethod(String methodName, Object obj) {
        this.addMethod(methodName, obj, obj.getClass());
    }

    public void addMethod(String methodName, Object obj, HproseResultMode mode) {
        this.addMethod(methodName, obj, obj.getClass(), mode);
    }

    public void addMethod(String methodName, Object obj, boolean simple) {
        this.addMethod(methodName, obj, obj.getClass(), simple);
    }

    public void addMethod(String methodName, Object obj, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, obj, obj.getClass(), mode, simple);
    }

    public void addMethod(String methodName, Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethod(methodName, obj, obj.getClass(), mode, simple, oneway);
    }

    public void addMethod(String methodName, Class<?> type) {
        this.addMethod(methodName, null, type);
    }

    public void addMethod(String methodName, Class<?> type, HproseResultMode mode) {
        this.addMethod(methodName, null, type, mode);
    }

    public void addMethod(String methodName, Class<?> type, boolean simple) {
        this.addMethod(methodName, null, type, simple);
    }

    public void addMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, null, type, mode, simple);
    }

    public void addMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethod(methodName, null, type, mode, simple, oneway);
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, String[] aliasNames, HproseMethodCreator creator) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methodNames.length; ++i) {
            String methodName = methodNames[i];
            String aliasName = aliasNames[i];
            for (Method method : methods) {
                if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
                this.addMethod(aliasName, creator.create(method));
            }
        }
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String[] aliasNames, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addMethods(methodNames, obj, type, aliasNames, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String[] aliasNames, final HproseResultMode mode, final boolean simple) {
        this.addMethods(methodNames, obj, type, aliasNames, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String[] aliasNames, final HproseResultMode mode) {
        this.addMethods(methodNames, obj, type, aliasNames, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String[] aliasNames, final boolean simple) {
        this.addMethods(methodNames, obj, type, aliasNames, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String[] aliasNames) {
        this.addMethods(methodNames, obj, type, aliasNames, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, String aliasPrefix, HproseMethodCreator creator) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methodNames.length; ++i) {
            String methodName = methodNames[i];
            for (Method method : methods) {
                if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
                HproseMethod m = creator.create(method);
                this.addMethod(aliasPrefix + "_" + m.aliasName, m);
            }
        }
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String aliasPrefix, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addMethods(methodNames, obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String aliasPrefix, final HproseResultMode mode, final boolean simple) {
        this.addMethods(methodNames, obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String aliasPrefix, final HproseResultMode mode) {
        this.addMethods(methodNames, obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String aliasPrefix, final boolean simple) {
        this.addMethods(methodNames, obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, String aliasPrefix) {
        this.addMethods(methodNames, obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, HproseMethodCreator creator) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methodNames.length; ++i) {
            String methodName = methodNames[i];
            for (Method method : methods) {
                if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
                this.addMethod(creator.create(method));
            }
        }
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addMethods(methodNames, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, final HproseResultMode mode, final boolean simple) {
        this.addMethods(methodNames, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, final HproseResultMode mode) {
        this.addMethods(methodNames, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type, final boolean simple) {
        this.addMethods(methodNames, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    private void addMethods(String[] methodNames, final Object obj, Class<?> type) {
        this.addMethods(methodNames, obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, mode);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, mode, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, mode, simple, oneway);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, mode);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, mode, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, mode, simple, oneway);
    }

    public void addMethods(String[] methodNames, Object obj) {
        this.addMethods(methodNames, obj, obj.getClass());
    }

    public void addMethods(String[] methodNames, Object obj, HproseResultMode mode) {
        this.addMethods(methodNames, obj, obj.getClass(), mode);
    }

    public void addMethods(String[] methodNames, Object obj, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), simple);
    }

    public void addMethods(String[] methodNames, Object obj, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), mode, simple);
    }

    public void addMethods(String[] methodNames, Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethods(methodNames, obj, obj.getClass(), mode, simple, oneway);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames) {
        this.addMethods(methodNames, null, type, aliasNames);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode) {
        this.addMethods(methodNames, null, type, aliasNames, mode);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, boolean simple) {
        this.addMethods(methodNames, null, type, aliasNames, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, null, type, aliasNames, mode, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethods(methodNames, null, type, aliasNames, mode, simple, oneway);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix) {
        this.addMethods(methodNames, null, type, aliasPrefix);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.addMethods(methodNames, null, type, aliasPrefix, mode);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, boolean simple) {
        this.addMethods(methodNames, null, type, aliasPrefix, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, null, type, aliasPrefix, mode, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethods(methodNames, null, type, aliasPrefix, mode, simple, oneway);
    }

    public void addMethods(String[] methodNames, Class<?> type) {
        this.addMethods(methodNames, null, type);
    }

    public void addMethods(String[] methodNames, Class<?> type, HproseResultMode mode) {
        this.addMethods(methodNames, null, type, mode);
    }

    public void addMethods(String[] methodNames, Class<?> type, boolean simple) {
        this.addMethods(methodNames, null, type, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, null, type, mode, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addMethods(methodNames, null, type, mode, simple, oneway);
    }

    private void addInstanceMethods(Object obj, Class<?> type, String aliasPrefix, HproseMethodCreator creator) {
        if (obj != null) {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
                HproseMethod m = creator.create(method);
                this.addMethod(aliasPrefix + "_" + m.aliasName, m);
            }
        }
    }

    public void addInstanceMethods(final Object obj, Class<?> type, String aliasPrefix, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addInstanceMethods(obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, String aliasPrefix, final HproseResultMode mode, final boolean simple) {
        this.addInstanceMethods(obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, String aliasPrefix, final boolean simple) {
        this.addInstanceMethods(obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, String aliasPrefix, final HproseResultMode mode) {
        this.addInstanceMethods(obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, String aliasPrefix) {
        this.addInstanceMethods(obj, type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    private void addInstanceMethods(Object obj, Class<?> type, HproseMethodCreator creator) {
        if (obj != null) {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
                this.addMethod(creator.create(method));
            }
        }
    }

    public void addInstanceMethods(final Object obj, Class<?> type, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addInstanceMethods(obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple, oneway);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, final HproseResultMode mode, final boolean simple) {
        this.addInstanceMethods(obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode, simple);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, final boolean simple) {
        this.addInstanceMethods(obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, simple);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type, final HproseResultMode mode) {
        this.addInstanceMethods(obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj, mode);
            }
        });
    }

    public void addInstanceMethods(final Object obj, Class<?> type) {
        this.addInstanceMethods(obj, type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, obj);
            }
        });
    }

    public void addInstanceMethods(Object obj, String aliasPrefix) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, HproseResultMode mode) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, mode);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, simple);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, mode, simple);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, mode, simple, oneway);
    }

    public void addInstanceMethods(Object obj) {
        this.addInstanceMethods(obj, obj.getClass());
    }

    public void addInstanceMethods(Object obj, HproseResultMode mode) {
        this.addInstanceMethods(obj, obj.getClass(), mode);
    }

    public void addInstanceMethods(Object obj, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), simple);
    }

    public void addInstanceMethods(Object obj, HproseResultMode mode, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), mode, simple);
    }

    public void addInstanceMethods(Object obj, HproseResultMode mode, boolean simple, boolean oneway) {
        this.addInstanceMethods(obj, obj.getClass(), mode, simple, oneway);
    }

    private void addStaticMethods(Class<?> type, String aliasPrefix, HproseMethodCreator creator) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            HproseMethod m = creator.create(method);
            this.addMethod(aliasPrefix + "_" + m.aliasName, m);
        }
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addStaticMethods(type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, mode, simple, oneway);
            }
        });
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, final HproseResultMode mode, final boolean simple) {
        this.addStaticMethods(type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, mode, simple);
            }
        });
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, final boolean simple) {
        this.addStaticMethods(type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, simple);
            }
        });
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, final HproseResultMode mode) {
        this.addStaticMethods(type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, mode);
            }
        });
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix) {
        this.addStaticMethods(type, aliasPrefix, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null);
            }
        });
    }

    private void addStaticMethods(Class<?> type, HproseMethodCreator creator) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            this.addMethod(creator.create(method));
        }
    }

    public void addStaticMethods(Class<?> type, final HproseResultMode mode, final boolean simple, final boolean oneway) {
        this.addStaticMethods(type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, mode, simple, oneway);
            }
        });
    }

    public void addStaticMethods(Class<?> type, final HproseResultMode mode, final boolean simple) {
        this.addStaticMethods(type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, mode, simple);
            }
        });
    }

    public void addStaticMethods(Class<?> type, final boolean simple) {
        this.addStaticMethods(type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, simple);
            }
        });
    }

    public void addStaticMethods(Class<?> type, final HproseResultMode mode) {
        this.addStaticMethods(type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null, mode);
            }
        });
    }

    public void addStaticMethods(Class<?> type) {
        this.addStaticMethods(type, new HproseMethodCreator(){

            @Override
            public HproseMethod create(Method method) {
                return new HproseMethod(method, null);
            }
        });
    }

    public void addMissingMethod(String methodName, Object obj) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*");
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", mode);
    }

    public void addMissingMethod(String methodName, Object obj, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", simple);
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", mode, simple);
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", mode, simple, oneway);
    }

    public void addMissingMethod(String methodName, Class<?> type) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*");
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", mode);
    }

    public void addMissingMethod(String methodName, Class<?> type, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", simple);
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", mode, simple);
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple, boolean oneway) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", mode, simple, oneway);
    }

    public void remove(String alias) {
        String name = alias.toLowerCase();
        this.methodNames.remove(name);
        this.remoteMethods.remove(name);
    }

    static interface HproseMethodCreator {
        public HproseMethod create(Method var1);
    }
}

