/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.access;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.rsf.hprose.io.HproseMode;
import net.hasor.rsf.hprose.io.access.BoolFieldAccessor;
import net.hasor.rsf.hprose.io.access.ByteFieldAccessor;
import net.hasor.rsf.hprose.io.access.CharFieldAccessor;
import net.hasor.rsf.hprose.io.access.DoubleFieldAccessor;
import net.hasor.rsf.hprose.io.access.FieldAccessor;
import net.hasor.rsf.hprose.io.access.FloatFieldAccessor;
import net.hasor.rsf.hprose.io.access.IntFieldAccessor;
import net.hasor.rsf.hprose.io.access.LongFieldAccessor;
import net.hasor.rsf.hprose.io.access.MemberAccessor;
import net.hasor.rsf.hprose.io.access.PropertyAccessor;
import net.hasor.rsf.hprose.io.access.SafeFieldAccessor;
import net.hasor.rsf.hprose.io.access.ShortFieldAccessor;
import net.hasor.rsf.hprose.util.ClassUtil;
import net.hasor.rsf.hprose.util.LinkedCaseInsensitiveMap;
import sun.misc.Unsafe;

public final class Accessors {
    private static final ConcurrentHashMap<Type, LinkedCaseInsensitiveMap<String, MemberAccessor>> propertiesCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Type, LinkedCaseInsensitiveMap<String, MemberAccessor>> membersCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Type, LinkedCaseInsensitiveMap<String, MemberAccessor>> fieldsCache = new ConcurrentHashMap();
    static final Unsafe unsafe = Accessors.getUnsafe();

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (Exception exception) {
            try {
                Class<Unsafe> k = Unsafe.class;
                for (Field f : k.getDeclaredFields()) {
                    f.setAccessible(true);
                    Object x = f.get(null);
                    if (!k.isInstance(x)) continue;
                    return (Unsafe)k.cast(x);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static final boolean isAndroid() {
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null) {
            return false;
        }
        String lowerVMName = vmName.toLowerCase();
        return lowerVMName.contains("dalvik") || lowerVMName.contains("lemur");
    }

    private static Method findGetter(Method[] methods, String name, Class<?> paramType) {
        String getterName = "get" + name;
        String isGetterName = "is" + name;
        for (Method method : methods) {
            String methodName;
            if (Modifier.isStatic(method.getModifiers()) || !(methodName = method.getName()).equals(getterName) && !methodName.equals(isGetterName) || !method.getReturnType().equals(paramType) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    private static Map<String, MemberAccessor> getProperties(Type type) {
        LinkedCaseInsensitiveMap<String, MemberAccessor> properties = propertiesCache.get(type);
        if (properties == null) {
            Method[] methods;
            properties = new LinkedCaseInsensitiveMap();
            for (Method setter : methods = ClassUtil.toClass(type).getMethods()) {
                String propertyName;
                Method getter;
                Class<?>[] paramTypes;
                String name;
                if (Modifier.isStatic(setter.getModifiers()) || !(name = setter.getName()).startsWith("set") || !setter.getReturnType().equals(Void.TYPE) || (paramTypes = setter.getParameterTypes()).length != 1 || (getter = Accessors.findGetter(methods, propertyName = name.substring(3), paramTypes[0])) == null) continue;
                PropertyAccessor propertyAccessor = new PropertyAccessor(type, getter, setter);
                char[] cname = propertyName.toCharArray();
                cname[0] = Character.toLowerCase(cname[0]);
                propertyName = new String(cname);
                properties.put(propertyName, propertyAccessor);
            }
            propertiesCache.put(type, properties);
        }
        return properties;
    }

    private static MemberAccessor getFieldAccessor(Type type, Field field) {
        if (unsafe != null && !Accessors.isAndroid()) {
            Class<?> cls = field.getType();
            if (cls == Integer.TYPE) {
                return new IntFieldAccessor(field);
            }
            if (cls == Byte.TYPE) {
                return new ByteFieldAccessor(field);
            }
            if (cls == Short.TYPE) {
                return new ShortFieldAccessor(field);
            }
            if (cls == Long.TYPE) {
                return new LongFieldAccessor(field);
            }
            if (cls == Boolean.TYPE) {
                return new BoolFieldAccessor(field);
            }
            if (cls == Character.TYPE) {
                return new CharFieldAccessor(field);
            }
            if (cls == Float.TYPE) {
                return new FloatFieldAccessor(field);
            }
            if (cls == Double.TYPE) {
                return new DoubleFieldAccessor(field);
            }
            return new FieldAccessor(type, field);
        }
        return new SafeFieldAccessor(type, field);
    }

    private static Map<String, MemberAccessor> getFields(Type type) {
        LinkedCaseInsensitiveMap<String, MemberAccessor> fields = fieldsCache.get(type);
        if (fields == null) {
            fields = new LinkedCaseInsensitiveMap();
            for (Class<?> clazz = ClassUtil.toClass(type); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fs;
                for (Field field : fs = clazz.getDeclaredFields()) {
                    int mod = field.getModifiers();
                    if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
                    String fieldName = field.getName();
                    fields.put(fieldName, Accessors.getFieldAccessor(type, field));
                }
            }
            fieldsCache.put(type, fields);
        }
        return fields;
    }

    private static Map<String, MemberAccessor> getMembers(Type type) {
        LinkedCaseInsensitiveMap<String, MemberAccessor> members = membersCache.get(type);
        if (members == null) {
            Field[] fs;
            Method[] methods;
            Class<?> clazz = ClassUtil.toClass(type);
            members = new LinkedCaseInsensitiveMap();
            for (Method setter : methods = clazz.getMethods()) {
                String propertyName;
                Method getter;
                Class<?>[] paramTypes;
                Class<?> returnType;
                String name;
                if (Modifier.isStatic(setter.getModifiers()) || !(name = setter.getName()).startsWith("set") || !(returnType = setter.getReturnType()).equals(Void.TYPE) && !returnType.isAssignableFrom(clazz) || (paramTypes = setter.getParameterTypes()).length != 1 || (getter = Accessors.findGetter(methods, propertyName = name.substring(3), paramTypes[0])) == null) continue;
                PropertyAccessor propertyAccessor = new PropertyAccessor(type, getter, setter);
                char[] cname = propertyName.toCharArray();
                cname[0] = Character.toLowerCase(cname[0]);
                propertyName = new String(cname);
                members.put(propertyName, propertyAccessor);
            }
            for (Field field : fs = clazz.getFields()) {
                int mod = field.getModifiers();
                if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
                String fieldName = field.getName();
                members.put(fieldName, Accessors.getFieldAccessor(type, field));
            }
            membersCache.put(type, members);
        }
        return members;
    }

    public static final Map<String, MemberAccessor> getMembers(Type type, HproseMode mode) {
        Class<?> clazz = ClassUtil.toClass(type);
        return mode != HproseMode.MemberMode && Serializable.class.isAssignableFrom(clazz) ? (mode == HproseMode.FieldMode ? Accessors.getFields(type) : Accessors.getProperties(type)) : Accessors.getMembers(type);
    }
}

