/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.access;

import java.io.IOException;
import java.lang.reflect.Field;
import net.hasor.rsf.hprose.common.HproseException;
import net.hasor.rsf.hprose.io.access.Accessors;
import net.hasor.rsf.hprose.io.access.MemberAccessor;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;
import net.hasor.rsf.hprose.io.unserialize.FloatUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;

public final class FloatFieldAccessor
implements MemberAccessor {
    private final long offset;

    public FloatFieldAccessor(Field accessor) {
        accessor.setAccessible(true);
        this.offset = Accessors.unsafe.objectFieldOffset(accessor);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        float value;
        try {
            value = Accessors.unsafe.getFloat(obj, this.offset);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
        ValueWriter.write(writer.stream, value);
    }

    @Override
    public void unserialize(Reader reader, Object obj) throws IOException {
        float value = FloatUnserializer.instance.read(reader).floatValue();
        try {
            Accessors.unsafe.putFloat(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e);
        }
    }
}

