/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.convert.java8;

import java.lang.reflect.Type;
import java.time.LocalDate;
import net.hasor.rsf.hprose.io.convert.Converter;
import net.hasor.rsf.hprose.util.DateTime;

public class LocalDateConverter
implements Converter<LocalDate> {
    public static final LocalDateConverter instance = new LocalDateConverter();

    public LocalDate convertTo(DateTime dt) {
        return LocalDate.of(dt.year, dt.month, dt.day);
    }

    public LocalDate convertTo(String str) {
        return LocalDate.parse(str);
    }

    public LocalDate convertTo(char[] chars) {
        return LocalDate.parse(new String(chars));
    }

    public LocalDate convertTo(long milli) {
        return LocalDate.ofEpochDay(milli);
    }

    public LocalDate convertTo(double milli) {
        return LocalDate.ofEpochDay((long)milli);
    }

    @Override
    public LocalDate convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return LocalDate.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return LocalDate.parse(new String((char[])obj));
        }
        if (obj instanceof Long) {
            return LocalDate.ofEpochDay((Long)obj);
        }
        if (obj instanceof Double) {
            return LocalDate.ofEpochDay(((Double)obj).longValue());
        }
        return (LocalDate)obj;
    }
}

