/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.convert.java8;

import java.lang.reflect.Type;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import net.hasor.rsf.hprose.io.convert.Converter;
import net.hasor.rsf.hprose.util.DateTime;
import net.hasor.rsf.hprose.util.TimeZoneUtil;

public class OffsetTimeConverter
implements Converter<OffsetTime> {
    public static final OffsetTimeConverter instance = new OffsetTimeConverter();

    public OffsetTime convertTo(DateTime dt) {
        return OffsetTime.of(dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID()));
    }

    @Override
    public OffsetTime convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return OffsetTime.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return OffsetTime.parse(new String((char[])obj));
        }
        return (OffsetTime)obj;
    }
}

