/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.convert.java8;

import java.lang.reflect.Type;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.hasor.rsf.hprose.io.convert.Converter;
import net.hasor.rsf.hprose.util.DateTime;
import net.hasor.rsf.hprose.util.TimeZoneUtil;

public class ZonedDateTimeConverter
implements Converter<ZonedDateTime> {
    public static final ZonedDateTimeConverter instance = new ZonedDateTimeConverter();

    public ZonedDateTime convertTo(DateTime dt) {
        return ZonedDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond, dt.utc ? ZoneOffset.UTC : ZoneOffset.of(TimeZoneUtil.DefaultTZ.getID()));
    }

    @Override
    public ZonedDateTime convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return ZonedDateTime.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return ZonedDateTime.parse(new String((char[])obj));
        }
        return (ZonedDateTime)obj;
    }
}

