/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize;

import java.io.IOException;
import java.io.OutputStream;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;
import net.hasor.rsf.hprose.util.DateTime;

public final class HproseDateTimeSerializer
extends ReferenceSerializer<DateTime> {
    public static final HproseDateTimeSerializer instance = new HproseDateTimeSerializer();

    @Override
    public final void serialize(Writer writer, DateTime dt) throws IOException {
        super.serialize(writer, dt);
        OutputStream stream = writer.stream;
        if (dt.year == 1970 && dt.month == 1 && dt.day == 1) {
            ValueWriter.writeTime(stream, dt.hour, dt.minute, dt.second, 0, false, true);
            ValueWriter.writeNano(stream, dt.nanosecond);
        } else {
            ValueWriter.writeDate(stream, dt.year, dt.month, dt.day);
            if (dt.nanosecond == 0) {
                ValueWriter.writeTime(stream, dt.hour, dt.minute, dt.second, 0, true, true);
            } else {
                ValueWriter.writeTime(stream, dt.hour, dt.minute, dt.second, 0, false, true);
                ValueWriter.writeNano(stream, dt.nanosecond);
            }
        }
        stream.write(dt.utc ? 90 : 59);
    }
}

