/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Pattern;
import net.hasor.rsf.hprose.io.serialize.AtomicBooleanSerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicIntegerArraySerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicIntegerSerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicLongArraySerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicLongSerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicReferenceArraySerializer;
import net.hasor.rsf.hprose.io.serialize.AtomicReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.BigDecimalArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BigDecimalSerializer;
import net.hasor.rsf.hprose.io.serialize.BigIntegerArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BigIntegerSerializer;
import net.hasor.rsf.hprose.io.serialize.BooleanArraySerializer;
import net.hasor.rsf.hprose.io.serialize.BooleanSerializer;
import net.hasor.rsf.hprose.io.serialize.ByteArraySerializer;
import net.hasor.rsf.hprose.io.serialize.ByteSerializer;
import net.hasor.rsf.hprose.io.serialize.BytesArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CalendarArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CalendarSerializer;
import net.hasor.rsf.hprose.io.serialize.CharArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CharSerializer;
import net.hasor.rsf.hprose.io.serialize.CharsArraySerializer;
import net.hasor.rsf.hprose.io.serialize.CollectionSerializer;
import net.hasor.rsf.hprose.io.serialize.DateArraySerializer;
import net.hasor.rsf.hprose.io.serialize.DateSerializer;
import net.hasor.rsf.hprose.io.serialize.DateTimeArraySerializer;
import net.hasor.rsf.hprose.io.serialize.DateTimeSerializer;
import net.hasor.rsf.hprose.io.serialize.DoubleArraySerializer;
import net.hasor.rsf.hprose.io.serialize.DoubleSerializer;
import net.hasor.rsf.hprose.io.serialize.EnumSerializer;
import net.hasor.rsf.hprose.io.serialize.FloatArraySerializer;
import net.hasor.rsf.hprose.io.serialize.FloatSerializer;
import net.hasor.rsf.hprose.io.serialize.HproseDateTimeSerializer;
import net.hasor.rsf.hprose.io.serialize.IntArraySerializer;
import net.hasor.rsf.hprose.io.serialize.IntegerSerializer;
import net.hasor.rsf.hprose.io.serialize.ListSerializer;
import net.hasor.rsf.hprose.io.serialize.LongArraySerializer;
import net.hasor.rsf.hprose.io.serialize.LongSerializer;
import net.hasor.rsf.hprose.io.serialize.MapSerializer;
import net.hasor.rsf.hprose.io.serialize.NullSerializer;
import net.hasor.rsf.hprose.io.serialize.ObjectSerializer;
import net.hasor.rsf.hprose.io.serialize.OtherTypeArraySerializer;
import net.hasor.rsf.hprose.io.serialize.OtherTypeSerializer;
import net.hasor.rsf.hprose.io.serialize.Serializer;
import net.hasor.rsf.hprose.io.serialize.ShortArraySerializer;
import net.hasor.rsf.hprose.io.serialize.ShortSerializer;
import net.hasor.rsf.hprose.io.serialize.StringArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringBufferArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringBufferSerializer;
import net.hasor.rsf.hprose.io.serialize.StringBuilderArraySerializer;
import net.hasor.rsf.hprose.io.serialize.StringBuilderSerializer;
import net.hasor.rsf.hprose.io.serialize.StringSerializer;
import net.hasor.rsf.hprose.io.serialize.TimeArraySerializer;
import net.hasor.rsf.hprose.io.serialize.TimeSerializer;
import net.hasor.rsf.hprose.io.serialize.TimeZoneSerializer;
import net.hasor.rsf.hprose.io.serialize.TimestampArraySerializer;
import net.hasor.rsf.hprose.io.serialize.TimestampSerializer;
import net.hasor.rsf.hprose.io.serialize.ToStringSerializer;
import net.hasor.rsf.hprose.io.serialize.UUIDArraySerializer;
import net.hasor.rsf.hprose.io.serialize.UUIDSerializer;
import net.hasor.rsf.hprose.util.DateTime;
import net.hasor.rsf.hprose.util.JdkVersion;

public final class SerializerFactory {
    private static final ConcurrentHashMap<Class<?>, Serializer> serializers = new ConcurrentHashMap();

    public static final Serializer get(Class<?> type) {
        Serializer<Enum> serializer = serializers.get(type);
        if (serializer == null) {
            serializer = type.isEnum() ? EnumSerializer.instance : (type.isArray() ? OtherTypeArraySerializer.instance : (Map.class.isAssignableFrom(type) ? MapSerializer.instance : (List.class.isAssignableFrom(type) ? ListSerializer.instance : (Collection.class.isAssignableFrom(type) ? CollectionSerializer.instance : (TimeZone.class.isAssignableFrom(type) ? TimeZoneSerializer.instance : (Calendar.class.isAssignableFrom(type) ? CalendarSerializer.instance : OtherTypeSerializer.instance))))));
            serializers.put(type, serializer);
        }
        return serializer;
    }

    public static final void register(Class<?> type, Serializer serializer) {
        serializers.put(type, serializer);
    }

    static {
        serializers.put(Void.TYPE, NullSerializer.instance);
        serializers.put(Boolean.TYPE, BooleanSerializer.instance);
        serializers.put(Character.TYPE, CharSerializer.instance);
        serializers.put(Byte.TYPE, ByteSerializer.instance);
        serializers.put(Short.TYPE, ShortSerializer.instance);
        serializers.put(Integer.TYPE, IntegerSerializer.instance);
        serializers.put(Long.TYPE, LongSerializer.instance);
        serializers.put(Float.TYPE, FloatSerializer.instance);
        serializers.put(Double.TYPE, DoubleSerializer.instance);
        serializers.put(Object.class, ObjectSerializer.instance);
        serializers.put(Void.class, NullSerializer.instance);
        serializers.put(Boolean.class, BooleanSerializer.instance);
        serializers.put(Character.class, CharSerializer.instance);
        serializers.put(Byte.class, ByteSerializer.instance);
        serializers.put(Short.class, ShortSerializer.instance);
        serializers.put(Integer.class, IntegerSerializer.instance);
        serializers.put(Long.class, LongSerializer.instance);
        serializers.put(Float.class, FloatSerializer.instance);
        serializers.put(Double.class, DoubleSerializer.instance);
        serializers.put(String.class, StringSerializer.instance);
        serializers.put(BigInteger.class, BigIntegerSerializer.instance);
        serializers.put(java.sql.Date.class, DateSerializer.instance);
        serializers.put(Time.class, TimeSerializer.instance);
        serializers.put(Timestamp.class, TimestampSerializer.instance);
        serializers.put(Date.class, DateTimeSerializer.instance);
        serializers.put(Calendar.class, CalendarSerializer.instance);
        serializers.put(BigDecimal.class, BigDecimalSerializer.instance);
        serializers.put(StringBuilder.class, StringBuilderSerializer.instance);
        serializers.put(StringBuffer.class, StringBufferSerializer.instance);
        serializers.put(UUID.class, UUIDSerializer.instance);
        serializers.put(boolean[].class, BooleanArraySerializer.instance);
        serializers.put(char[].class, CharArraySerializer.instance);
        serializers.put(byte[].class, ByteArraySerializer.instance);
        serializers.put(short[].class, ShortArraySerializer.instance);
        serializers.put(int[].class, IntArraySerializer.instance);
        serializers.put(long[].class, LongArraySerializer.instance);
        serializers.put(float[].class, FloatArraySerializer.instance);
        serializers.put(double[].class, DoubleArraySerializer.instance);
        serializers.put(String[].class, StringArraySerializer.instance);
        serializers.put(BigInteger[].class, BigIntegerArraySerializer.instance);
        serializers.put(java.sql.Date[].class, DateArraySerializer.instance);
        serializers.put(Time[].class, TimeArraySerializer.instance);
        serializers.put(Timestamp[].class, TimestampArraySerializer.instance);
        serializers.put(Date[].class, DateTimeArraySerializer.instance);
        serializers.put(Calendar[].class, CalendarArraySerializer.instance);
        serializers.put(BigDecimal[].class, BigDecimalArraySerializer.instance);
        serializers.put(StringBuilder[].class, StringBuilderArraySerializer.instance);
        serializers.put(StringBuffer[].class, StringBufferArraySerializer.instance);
        serializers.put(UUID[].class, UUIDArraySerializer.instance);
        serializers.put(char[][].class, CharsArraySerializer.instance);
        serializers.put(byte[][].class, BytesArraySerializer.instance);
        serializers.put(ArrayList.class, ListSerializer.instance);
        serializers.put(AbstractList.class, ListSerializer.instance);
        serializers.put(AbstractCollection.class, CollectionSerializer.instance);
        serializers.put(List.class, ListSerializer.instance);
        serializers.put(Collection.class, CollectionSerializer.instance);
        serializers.put(LinkedList.class, ListSerializer.instance);
        serializers.put(AbstractSequentialList.class, ListSerializer.instance);
        serializers.put(HashSet.class, CollectionSerializer.instance);
        serializers.put(AbstractSet.class, CollectionSerializer.instance);
        serializers.put(Set.class, CollectionSerializer.instance);
        serializers.put(TreeSet.class, CollectionSerializer.instance);
        serializers.put(SortedSet.class, CollectionSerializer.instance);
        serializers.put(HashMap.class, MapSerializer.instance);
        serializers.put(AbstractMap.class, MapSerializer.instance);
        serializers.put(Map.class, MapSerializer.instance);
        serializers.put(TreeMap.class, MapSerializer.instance);
        serializers.put(SortedMap.class, MapSerializer.instance);
        serializers.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        serializers.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        serializers.put(AtomicLong.class, AtomicLongSerializer.instance);
        serializers.put(AtomicReference.class, AtomicReferenceSerializer.instance);
        serializers.put(AtomicIntegerArray.class, AtomicIntegerArraySerializer.instance);
        serializers.put(AtomicLongArray.class, AtomicLongArraySerializer.instance);
        serializers.put(AtomicReferenceArray.class, AtomicReferenceArraySerializer.instance);
        serializers.put(Locale.class, ToStringSerializer.instance);
        serializers.put(URI.class, ToStringSerializer.instance);
        serializers.put(URL.class, ToStringSerializer.instance);
        serializers.put(Pattern.class, ToStringSerializer.instance);
        serializers.put(TimeZone.class, TimeZoneSerializer.instance);
        serializers.put(DateTime.class, HproseDateTimeSerializer.instance);
        if (JdkVersion.majorJavaVersion >= 8) {
            try {
                Class.forName("net.hasor.rsf.hprose.io.serialize.java8.SerializerLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

