/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize.java8;

import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;

public final class LocalDateSerializer
extends ReferenceSerializer<LocalDate> {
    public static final LocalDateSerializer instance = new LocalDateSerializer();

    @Override
    public final void serialize(Writer writer, LocalDate date) throws IOException {
        super.serialize(writer, date);
        OutputStream stream = writer.stream;
        int year = date.getYear();
        if (year > 9999 || year < 1) {
            stream.write(115);
            ValueWriter.write(stream, date.toString());
        } else {
            ValueWriter.writeDate(stream, year, date.getMonthValue(), date.getDayOfMonth());
            stream.write(59);
        }
    }
}

