/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize.java8;

import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;

public final class OffsetDateTimeSerializer
extends ReferenceSerializer<OffsetDateTime> {
    public static final OffsetDateTimeSerializer instance = new OffsetDateTimeSerializer();

    @Override
    public final void serialize(Writer writer, OffsetDateTime datetime) throws IOException {
        super.serialize(writer, datetime);
        OutputStream stream = writer.stream;
        if (!datetime.getOffset().equals(ZoneOffset.UTC)) {
            stream.write(115);
            ValueWriter.write(stream, datetime.toString());
        } else {
            int year = datetime.getYear();
            if (year > 9999 || year < 1) {
                stream.write(115);
                ValueWriter.write(stream, datetime.toString());
            } else {
                ValueWriter.writeDate(stream, year, datetime.getMonthValue(), datetime.getDayOfMonth());
                ValueWriter.writeTime(stream, datetime.getHour(), datetime.getMinute(), datetime.getSecond(), 0, false, true);
                ValueWriter.writeNano(stream, datetime.getNano());
                stream.write(90);
            }
        }
    }
}

