/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize.java8;

import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;

public final class OffsetTimeSerializer
extends ReferenceSerializer<OffsetTime> {
    public static final OffsetTimeSerializer instance = new OffsetTimeSerializer();

    @Override
    public final void serialize(Writer writer, OffsetTime time) throws IOException {
        super.serialize(writer, time);
        OutputStream stream = writer.stream;
        if (!time.getOffset().equals(ZoneOffset.UTC)) {
            stream.write(115);
            ValueWriter.write(stream, time.toString());
        } else {
            ValueWriter.writeTime(stream, time.getHour(), time.getMinute(), time.getSecond(), 0, false, true);
            ValueWriter.writeNano(stream, time.getNano());
            stream.write(90);
        }
    }
}

