/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.serialize.java8;

import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.hasor.rsf.hprose.io.serialize.ReferenceSerializer;
import net.hasor.rsf.hprose.io.serialize.ValueWriter;
import net.hasor.rsf.hprose.io.serialize.Writer;

public final class ZonedDateTimeSerializer
extends ReferenceSerializer<ZonedDateTime> {
    public static final ZonedDateTimeSerializer instance = new ZonedDateTimeSerializer();

    @Override
    public final void serialize(Writer writer, ZonedDateTime datetime) throws IOException {
        super.serialize(writer, datetime);
        OutputStream stream = writer.stream;
        if (!datetime.getOffset().equals(ZoneOffset.UTC)) {
            stream.write(115);
            ValueWriter.write(stream, datetime.toString());
        } else {
            int year = datetime.getYear();
            if (year > 9999 || year < 1) {
                stream.write(115);
                ValueWriter.write(stream, datetime.toString());
            } else {
                ValueWriter.writeDate(stream, year, datetime.getMonthValue(), datetime.getDayOfMonth());
                ValueWriter.writeTime(stream, datetime.getHour(), datetime.getMinute(), datetime.getSecond(), 0, false, true);
                ValueWriter.writeNano(stream, datetime.getNano());
                stream.write(90);
            }
        }
    }
}

