/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public final class BigIntegerUnserializer
extends BaseUnserializer<BigInteger> {
    public static final BigIntegerUnserializer instance = new BigIntegerUnserializer();

    @Override
    public BigInteger unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag >= 48 && tag <= 57) {
            return BigInteger.valueOf(tag - 48);
        }
        switch (tag) {
            case 100: 
            case 105: 
            case 108: {
                return new BigInteger(ValueReader.readUntil(reader, 59).toString());
            }
            case 101: {
                return BigInteger.ZERO;
            }
            case 116: {
                return BigInteger.ONE;
            }
            case 102: {
                return BigInteger.ZERO;
            }
            case 68: {
                return ReferenceReader.readDateTime(reader).toBigInteger();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toBigInteger();
            }
            case 117: {
                return new BigInteger(ValueReader.readUTF8Char(reader));
            }
            case 115: {
                return new BigInteger(ReferenceReader.readString(reader));
            }
        }
        return (BigInteger)super.unserialize(reader, tag, type);
    }

    public BigInteger read(Reader reader) throws IOException {
        return (BigInteger)this.read(reader, (Type)((Object)BigInteger.class));
    }
}

