/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public class BooleanObjectUnserializer
extends BaseUnserializer<Boolean> {
    public static final BooleanObjectUnserializer instance = new BooleanObjectUnserializer();

    @Override
    public Boolean unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag == 116) {
            return true;
        }
        if (tag == 102) {
            return false;
        }
        if (tag == 48) {
            return false;
        }
        if (tag >= 49 && tag <= 57) {
            return true;
        }
        switch (tag) {
            case 105: {
                return ValueReader.readInt(reader) != 0;
            }
            case 108: {
                return !BigInteger.ZERO.equals(ValueReader.readBigInteger(reader));
            }
            case 100: {
                return ValueReader.readDouble(reader) != 0.0;
            }
            case 101: {
                return false;
            }
            case 78: {
                return true;
            }
            case 73: {
                reader.stream.read();
                return true;
            }
            case 117: {
                return "\u0000".indexOf(ValueReader.readChar(reader)) == -1;
            }
            case 115: {
                return Boolean.parseBoolean(ReferenceReader.readString(reader));
            }
        }
        return (Boolean)super.unserialize(reader, tag, type);
    }

    public Boolean read(Reader reader) throws IOException {
        return (Boolean)this.read(reader, (Type)((Object)Boolean.class));
    }
}

