/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;

public class FloatObjectUnserializer
extends BaseUnserializer<Float> {
    public static final FloatObjectUnserializer instance = new FloatObjectUnserializer();

    @Override
    public Float unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag == 100) {
            return Float.valueOf(ValueReader.readFloat(reader));
        }
        if (tag >= 48 && tag <= 57) {
            return Float.valueOf(tag - 48);
        }
        if (tag == 105) {
            return Float.valueOf(ValueReader.readInt(reader, 59));
        }
        switch (tag) {
            case 108: {
                return Float.valueOf(ValueReader.readLongAsFloat(reader));
            }
            case 101: {
                return Float.valueOf(0.0f);
            }
            case 116: {
                return Float.valueOf(1.0f);
            }
            case 102: {
                return Float.valueOf(0.0f);
            }
            case 78: {
                return Float.valueOf(Float.NaN);
            }
            case 73: {
                return Float.valueOf(ValueReader.readFloatInfinity(reader));
            }
            case 117: {
                return Float.valueOf(ValueReader.parseFloat(ValueReader.readUTF8Char(reader)));
            }
            case 115: {
                return Float.valueOf(ValueReader.parseFloat(ReferenceReader.readString(reader)));
            }
        }
        return (Float)super.unserialize(reader, tag, type);
    }

    public Float read(Reader reader) throws IOException {
        return (Float)this.read(reader, (Type)((Object)Float.class));
    }
}

