/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.hprose.io.unserialize;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import net.hasor.rsf.hprose.io.unserialize.BaseUnserializer;
import net.hasor.rsf.hprose.io.unserialize.Reader;
import net.hasor.rsf.hprose.io.unserialize.ReferenceReader;
import net.hasor.rsf.hprose.io.unserialize.ValueReader;
import net.hasor.rsf.hprose.util.DateTime;

public final class HproseDateTimeUnserializer
extends BaseUnserializer<DateTime> {
    public static final HproseDateTimeUnserializer instance = new HproseDateTimeUnserializer();

    @Override
    public DateTime unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 68: {
                return ReferenceReader.readDateTime(reader);
            }
            case 84: {
                return ReferenceReader.readTime(reader);
            }
            case 101: {
                return null;
            }
            case 115: {
                return new DateTime(new Date(ReferenceReader.readString(reader)));
            }
            case 105: 
            case 108: {
                return new DateTime(new Date(ValueReader.readLong(reader)));
            }
            case 100: {
                return new DateTime(new Date((long)ValueReader.readDouble(reader)));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new DateTime(new Date(tag - 48));
        }
        return (DateTime)super.unserialize(reader, tag, type);
    }

    public DateTime read(Reader reader) throws IOException {
        return (DateTime)this.read(reader, (Type)((Object)DateTime.class));
    }
}

